/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.query.QueryResponse;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.util.GrpcMetaData;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;

public class GrpcBackedResponseMessage<R>
implements QueryResponseMessage<R> {
    private final QueryResponse queryResponse;
    private final LazyDeserializingObject<R> serializedPayload;
    private final Throwable exception;
    private final Supplier<MetaData> metaDataSupplier;
    private final MessageType type;

    public GrpcBackedResponseMessage(QueryResponse queryResponse, Serializer serializer) {
        this.queryResponse = queryResponse;
        LazyDeserializingObject<R> lazyDeserializingObject = this.serializedPayload = queryResponse.hasPayload() && !SerializedType.emptyType().getName().equalsIgnoreCase(queryResponse.getPayload().getType()) ? new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryResponse.getPayload()), serializer) : null;
        this.exception = queryResponse.hasErrorMessage() ? ErrorCode.getFromCode(queryResponse.getErrorCode()).convert(queryResponse.getErrorMessage(), this.serializedPayload == null ? () -> null : () -> this.serializedPayload.getObject()) : null;
        this.metaDataSupplier = new GrpcMetaData(queryResponse.getMetaDataMap(), serializer);
        this.type = this.serializedPayload != null ? new MessageType(serializer.classForType(new GrpcSerializedObject(queryResponse.getPayload()).getType())) : new MessageType(queryResponse.getErrorCode());
    }

    private GrpcBackedResponseMessage(QueryResponse queryResponse, LazyDeserializingObject<R> serializedPayload, Throwable exception, Supplier<MetaData> metaDataSupplier, MessageType type) {
        this.queryResponse = queryResponse;
        this.serializedPayload = serializedPayload;
        this.exception = exception;
        this.metaDataSupplier = metaDataSupplier;
        this.type = type;
    }

    public String getIdentifier() {
        return this.queryResponse.getMessageIdentifier();
    }

    @Nonnull
    public MessageType type() {
        return this.type;
    }

    public MetaData getMetaData() {
        return this.metaDataSupplier.get();
    }

    public R getPayload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.exception);
        }
        return (R)(this.serializedPayload == null ? null : this.serializedPayload.getObject());
    }

    public Class<R> getPayloadType() {
        return this.serializedPayload == null ? null : this.serializedPayload.getType();
    }

    public boolean isExceptional() {
        return this.exception != null;
    }

    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    public GrpcBackedResponseMessage<R> withMetaData(@Nonnull Map<String, String> metaData) {
        return new GrpcBackedResponseMessage<R>(this.queryResponse, this.serializedPayload, this.exception, () -> MetaData.from((Map)metaData), this.type);
    }

    public GrpcBackedResponseMessage<R> andMetaData(@Nonnull Map<String, String> metaData) {
        return this.withMetaData((Map)this.getMetaData().mergedWith(metaData));
    }
}

