/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import org.axonframework.common.AxonThreadFactory;

@FunctionalInterface
public interface PersistentStreamScheduledExecutorBuilder
extends BiFunction<Integer, String, ScheduledExecutorService> {
    default public ScheduledExecutorService build(Integer threadCount, String streamName) {
        return (ScheduledExecutorService)this.apply(threadCount, streamName);
    }

    public static PersistentStreamScheduledExecutorBuilder defaultFactory() {
        return (threadCount, streamName) -> Executors.newScheduledThreadPool(threadCount, (ThreadFactory)new AxonThreadFactory("PersistentStream[" + streamName + "]"));
    }
}

