/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.event.dcb.Event;
import io.axoniq.axonserver.grpc.event.dcb.Tag;
import io.axoniq.axonserver.grpc.event.dcb.TaggedEvent;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.eventstore.TaggedEventMessage;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Converter;

@Internal
public class EventConverter
implements DescribableComponent {
    private final Converter converter;

    public EventConverter(@Nonnull Converter converter) {
        this.converter = Objects.requireNonNull(converter, "The converter cannot be null.");
    }

    public TaggedEvent convertTaggedEventMessage(@Nonnull TaggedEventMessage<?> taggedEvent) {
        return TaggedEvent.newBuilder().setEvent(this.convertEventMessage(taggedEvent.event())).addAllTag(EventConverter.convertTags(taggedEvent.tags())).build();
    }

    private Event convertEventMessage(EventMessage<?> eventMessage) {
        return Event.newBuilder().setIdentifier(eventMessage.getIdentifier()).setTimestamp(eventMessage.getTimestamp().toEpochMilli()).setName(eventMessage.type().name()).setVersion(eventMessage.type().version()).setPayload(this.convertPayload(eventMessage.getPayload())).putAllMetadata(this.convertMetaData(eventMessage.getMetaData())).build();
    }

    private ByteString convertPayload(Object payload) {
        return ByteString.copyFrom((byte[])((byte[])this.converter.convert(payload, byte[].class)));
    }

    private Map<String, String> convertMetaData(MetaData metaData) {
        return metaData.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static List<Tag> convertTags(Set<org.axonframework.eventstreaming.Tag> tags) {
        return tags.stream().map(EventConverter::convertTag).collect(Collectors.toList());
    }

    private static Tag convertTag(org.axonframework.eventstreaming.Tag tag) {
        return Tag.newBuilder().setKey(EventConverter.convertString(tag.key())).setValue(EventConverter.convertString(tag.value())).build();
    }

    private static ByteString convertString(String s) {
        return ByteString.copyFrom((String)s, (Charset)StandardCharsets.UTF_8);
    }

    public EventMessage<byte[]> convertEvent(@Nonnull Event event) {
        return new GenericEventMessage(event.getIdentifier(), new MessageType(event.getName(), event.getVersion()), (Object)event.getPayload().toByteArray(), event.getMetadataMap(), Instant.ofEpochMilli(event.getTimestamp()));
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("converter", (Object)this.converter);
    }
}

