/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.axonframework.axonserver.connector.PriorityTask;

public class PriorityCallable<T>
implements Callable<T>,
PriorityTask {
    private final Callable<T> task;
    private final long priority;
    private final long sequence;

    public PriorityCallable(Callable<T> task, long priority, long sequence) {
        this.task = task;
        this.priority = priority;
        this.sequence = sequence;
    }

    @Override
    public T call() throws Exception {
        return this.task.call();
    }

    @Override
    public long priority() {
        return this.priority;
    }

    @Override
    public long sequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriorityCallable that = (PriorityCallable)o;
        return this.priority == that.priority && this.sequence == that.sequence && Objects.equals(this.task, that.task);
    }

    public int hashCode() {
        return Objects.hash(this.task, this.priority, this.sequence);
    }

    public String toString() {
        return "PriorityCallable{task=" + String.valueOf(this.task) + ", priority=" + this.priority + ", sequence=" + this.sequence + "}";
    }
}

