/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event;

import io.axoniq.axonserver.connector.AxonServerConnection;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.event.AxonServerEventStorageEngine;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.InstantiatedComponentDefinition;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.serialization.Converter;

public class AxonServerEventStorageEngineFactory
implements ComponentFactory<AxonServerEventStorageEngine> {
    public static final String ENGINE_PREFIX = "storageEngine";
    public static final String CONTEXT_DELIMITER = "@";

    @Nonnull
    public static AxonServerEventStorageEngine constructForContext(@Nonnull String context, @Nonnull Configuration config) {
        AxonServerConnection connection = ((AxonServerConnectionManager)config.getComponent(AxonServerConnectionManager.class)).getConnection(context);
        return new AxonServerEventStorageEngine(connection, (Converter)config.getComponent(Converter.class));
    }

    @Nonnull
    public Class<AxonServerEventStorageEngine> forType() {
        return AxonServerEventStorageEngine.class;
    }

    @Nonnull
    public Optional<Component<AxonServerEventStorageEngine>> construct(@Nonnull String name, @Nonnull Configuration config) {
        return AxonServerEventStorageEngineFactory.contextNameFrom(name).map(context -> AxonServerEventStorageEngineFactory.constructForContext(context, config)).map(engine -> new InstantiatedComponentDefinition(new Component.Identifier(this.forType(), name), engine));
    }

    public void registerShutdownHandlers(@Nonnull LifecycleRegistry registry) {
    }

    private static Optional<String> contextNameFrom(String name) {
        return name.startsWith("storageEngine@") ? Optional.of(name.substring(name.indexOf(CONTEXT_DELIMITER))) : Optional.empty();
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("type", this.forType());
        descriptor.describeProperty("nameFormat", "storageEngine@{context-name}");
    }
}

