/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.control.NodeInfo;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.axonserver.connector.event.util.EventCipher;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="axon.axonserver")
public class AxonServerConfiguration {
    private static final int DEFAULT_GRPC_PORT = 8124;
    private static final String DEFAULT_SERVERS = "localhost";
    private static final String DEFAULT_CONTEXT = "default";
    private boolean enabled = true;
    private String servers = "localhost";
    private String clientId = ManagementFactory.getRuntimeMXBean().getName();
    private String componentName;
    private String token;
    private String context = "default";
    private String certFile;
    private boolean sslEnabled;
    private Integer initialNrOfPermits = 5000;
    private Integer nrOfNewPermits = null;
    private Integer newPermitsThreshold = null;
    private FlowControlConfiguration eventFlowControl;
    private FlowControlConfiguration queryFlowControl;
    private FlowControlConfiguration commandFlowControl;
    private int commandThreads = 10;
    private int queryThreads = 10;
    private int processorsNotificationRate = 500;
    private int processorsNotificationInitialDelay = 5000;
    @Deprecated
    private EventCipher eventCipher = new EventCipher();
    private long keepAliveTimeout = 5000L;
    private long keepAliveTime = 1000L;
    private int snapshotPrefetch = 1;
    private boolean suppressDownloadMessage = false;
    private int maxMessageSize = 0;
    private int commitTimeout = 10000;
    private boolean disableEventBlacklisting = false;
    private int maxGrpcBufferedMessages = 500;
    private int commandLoadFactor = 100;
    private long connectTimeout = 5000L;
    private boolean forceReadFromLeader = false;
    private HeartbeatConfiguration heartbeat = new HeartbeatConfiguration();

    public static Builder builder() {
        Builder builder = new Builder();
        if (Boolean.getBoolean("axon.axonserver.suppressDownloadMessage")) {
            builder.suppressDownloadMessage();
        }
        return builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String routingServers) {
        this.servers = routingServers;
        this.suppressDownloadMessage = true;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getComponentName() {
        return this.componentName == null ? System.getProperty("axon.application.name", "Unnamed-" + this.clientId) : this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCertFile() {
        return this.certFile;
    }

    public void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Integer getInitialNrOfPermits() {
        return this.initialNrOfPermits;
    }

    public void setInitialNrOfPermits(Integer initialNrOfPermits) {
        this.initialNrOfPermits = initialNrOfPermits;
    }

    public Integer getNrOfNewPermits() {
        if (this.nrOfNewPermits == null || this.nrOfNewPermits <= 0) {
            return this.getInitialNrOfPermits() - this.getNewPermitsThreshold();
        }
        return this.nrOfNewPermits;
    }

    public void setNrOfNewPermits(Integer nrOfNewPermits) {
        this.nrOfNewPermits = nrOfNewPermits;
    }

    public Integer getNewPermitsThreshold() {
        if (this.newPermitsThreshold == null || this.newPermitsThreshold <= 0) {
            return this.initialNrOfPermits / 2;
        }
        return this.newPermitsThreshold;
    }

    public void setNewPermitsThreshold(Integer newPermitsThreshold) {
        this.newPermitsThreshold = newPermitsThreshold;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<NodeInfo> routingServers() {
        String[] serverArr = this.servers.split(",");
        return Arrays.stream(serverArr).map(server -> {
            String[] s = server.trim().split(":");
            if (s.length > 1) {
                return NodeInfo.newBuilder().setHostName(s[0]).setGrpcPort(Integer.parseInt(s[1])).build();
            }
            return NodeInfo.newBuilder().setHostName(s[0]).setGrpcPort(8124).build();
        }).collect(Collectors.toList());
    }

    public EventCipher getEventCipher() {
        return this.eventCipher;
    }

    private void setEventSecretKey(String key) {
        if (key != null && key.length() > 0) {
            this.eventCipher = new EventCipher(key.getBytes(StandardCharsets.US_ASCII));
        }
    }

    public Integer getCommandThreads() {
        return this.commandThreads;
    }

    public void setCommandThreads(Integer commandThreads) {
        this.commandThreads = commandThreads;
    }

    public void setCommandThreads(int commandThreads) {
        this.commandThreads = commandThreads;
    }

    public int getQueryThreads() {
        return this.queryThreads;
    }

    public void setQueryThreads(int queryThreads) {
        this.queryThreads = queryThreads;
    }

    public int getProcessorsNotificationRate() {
        return this.processorsNotificationRate;
    }

    public void setProcessorsNotificationRate(int processorsNotificationRate) {
        this.processorsNotificationRate = processorsNotificationRate;
    }

    public int getProcessorsNotificationInitialDelay() {
        return this.processorsNotificationInitialDelay;
    }

    public void setProcessorsNotificationInitialDelay(int processorsNotificationInitialDelay) {
        this.processorsNotificationInitialDelay = processorsNotificationInitialDelay;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public boolean getSuppressDownloadMessage() {
        return this.suppressDownloadMessage;
    }

    public void setSuppressDownloadMessage(boolean suppressDownloadMessage) {
        this.suppressDownloadMessage = suppressDownloadMessage;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getSnapshotPrefetch() {
        return this.snapshotPrefetch;
    }

    public void setSnapshotPrefetch(int snapshotPrefetch) {
        this.snapshotPrefetch = snapshotPrefetch;
    }

    public boolean isDisableEventBlacklisting() {
        return this.disableEventBlacklisting;
    }

    public void setDisableEventBlacklisting(boolean disableEventBlacklisting) {
        this.disableEventBlacklisting = disableEventBlacklisting;
    }

    public int getCommitTimeout() {
        return this.commitTimeout;
    }

    public void setCommitTimeout(int commitTimeout) {
        this.commitTimeout = commitTimeout;
    }

    public int getMaxGrpcBufferedMessages() {
        return this.maxGrpcBufferedMessages;
    }

    public void setMaxGrpcBufferedMessages(int maxGrpcBufferedMessages) {
        this.maxGrpcBufferedMessages = maxGrpcBufferedMessages;
    }

    public int getCommandLoadFactor() {
        return this.commandLoadFactor;
    }

    public void setCommandLoadFactor(int commandLoadFactor) {
        this.commandLoadFactor = commandLoadFactor;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isForceReadFromLeader() {
        return this.forceReadFromLeader;
    }

    public void setForceReadFromLeader(boolean forceReadFromLeader) {
        this.forceReadFromLeader = forceReadFromLeader;
    }

    public FlowControlConfiguration getEventFlowControl() {
        if (this.eventFlowControl == null) {
            return new FlowControlConfiguration(this.getInitialNrOfPermits(), this.getNrOfNewPermits(), this.getNewPermitsThreshold());
        }
        return this.eventFlowControl;
    }

    public void setEventFlowControl(FlowControlConfiguration eventFlowControl) {
        this.eventFlowControl = eventFlowControl;
    }

    public FlowControlConfiguration getQueryFlowControl() {
        if (this.queryFlowControl == null) {
            return new FlowControlConfiguration(this.getInitialNrOfPermits(), this.getNrOfNewPermits(), this.getNewPermitsThreshold());
        }
        return this.queryFlowControl;
    }

    public void setQueryFlowControl(FlowControlConfiguration queryFlowControl) {
        this.queryFlowControl = queryFlowControl;
    }

    public FlowControlConfiguration getCommandFlowControl() {
        if (this.commandFlowControl == null) {
            return new FlowControlConfiguration(this.getInitialNrOfPermits(), this.getNrOfNewPermits(), this.getNewPermitsThreshold());
        }
        return this.commandFlowControl;
    }

    public void setCommandFlowControl(FlowControlConfiguration commandFlowControl) {
        this.commandFlowControl = commandFlowControl;
    }

    public FlowControlConfiguration getDefaultFlowControlConfiguration() {
        return new FlowControlConfiguration(this.initialNrOfPermits, this.nrOfNewPermits, this.newPermitsThreshold);
    }

    public HeartbeatConfiguration getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(HeartbeatConfiguration heartbeat) {
        this.heartbeat = heartbeat;
    }

    public static class Builder {
        private final AxonServerConfiguration instance = new AxonServerConfiguration();

        public Builder() {
            this.instance.initialNrOfPermits = 1000;
            this.instance.nrOfNewPermits = 500;
            this.instance.newPermitsThreshold = 500;
        }

        public Builder ssl(String certFile) {
            this.instance.certFile = certFile;
            this.instance.sslEnabled = true;
            return this;
        }

        public Builder token(String token) {
            this.instance.token = token;
            return this;
        }

        public Builder context(String context) {
            this.instance.context = context;
            return this;
        }

        public Builder forceReadFromLeader(boolean forceReadFromLeader) {
            this.instance.forceReadFromLeader = forceReadFromLeader;
            return this;
        }

        public Builder flowControl(int initialNrOfPermits, int nrOfNewPermits, int newPermitsThreshold) {
            this.instance.initialNrOfPermits = initialNrOfPermits;
            this.instance.nrOfNewPermits = nrOfNewPermits;
            this.instance.newPermitsThreshold = newPermitsThreshold;
            return this;
        }

        public Builder commandFlowControl(int initialNrOfPermits, int nrOfNewPermits, int newPermitsThreshold) {
            this.instance.setCommandFlowControl(new FlowControlConfiguration(initialNrOfPermits, nrOfNewPermits, newPermitsThreshold));
            return this;
        }

        public Builder queryFlowControl(int initialNrOfPermits, int nrOfNewPermits, int newPermitsThreshold) {
            this.instance.setQueryFlowControl(new FlowControlConfiguration(initialNrOfPermits, nrOfNewPermits, newPermitsThreshold));
            return this;
        }

        public Builder eventFlowControl(int initialNrOfPermits, int nrOfNewPermits, int newPermitsThreshold) {
            this.instance.setEventFlowControl(new FlowControlConfiguration(initialNrOfPermits, nrOfNewPermits, newPermitsThreshold));
            return this;
        }

        public Builder setEventSecretKey(String key) {
            this.instance.setEventSecretKey(key);
            return this;
        }

        public Builder eventCipher(EventCipher eventCipher) {
            this.instance.eventCipher = eventCipher;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.instance.maxMessageSize = maxMessageSize;
            return this;
        }

        public Builder snapshotPrefetch(int snapshotPrefetch) {
            this.instance.snapshotPrefetch = snapshotPrefetch;
            return this;
        }

        public Builder commandLoadFactor(int commandLoadFactor) {
            this.instance.commandLoadFactor = commandLoadFactor;
            return this;
        }

        public AxonServerConfiguration build() {
            return this.instance;
        }

        public Builder servers(String servers) {
            this.instance.setServers(servers);
            return this;
        }

        public Builder suppressDownloadMessage() {
            this.instance.setSuppressDownloadMessage(true);
            return this;
        }

        public Builder componentName(String componentName) {
            this.instance.setComponentName(componentName);
            return this;
        }

        public Builder clientId(String clientId) {
            this.instance.setClientId(clientId);
            return this;
        }

        public Builder connectTimeout(long timeout) {
            this.instance.setConnectTimeout(timeout);
            return this;
        }
    }

    public static class HeartbeatConfiguration {
        private static final long DEFAULT_INTERVAL = 10000L;
        private static final long DEFAULT_TIMEOUT = 7500L;
        private boolean enabled = true;
        private long interval = 10000L;
        private long timeout = 7500L;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }
    }

    public static class FlowControlConfiguration {
        private Integer initialNrOfPermits = 5000;
        private Integer nrOfNewPermits = null;
        private Integer newPermitsThreshold = null;

        public FlowControlConfiguration() {
        }

        public FlowControlConfiguration(Integer initialNrOfPermits, Integer nrOfNewPermits, Integer newPermitsThreshold) {
            this.initialNrOfPermits = initialNrOfPermits;
            this.nrOfNewPermits = nrOfNewPermits;
            this.newPermitsThreshold = newPermitsThreshold;
        }

        public Integer getInitialNrOfPermits() {
            return this.initialNrOfPermits;
        }

        public void setInitialNrOfPermits(Integer initialNrOfPermits) {
            this.initialNrOfPermits = initialNrOfPermits;
        }

        public Integer getNrOfNewPermits() {
            if (this.nrOfNewPermits == null || this.nrOfNewPermits <= 0) {
                return this.getInitialNrOfPermits() - this.getNewPermitsThreshold();
            }
            return this.nrOfNewPermits;
        }

        public void setNrOfNewPermits(Integer nrOfNewPermits) {
            this.nrOfNewPermits = nrOfNewPermits;
        }

        public Integer getNewPermitsThreshold() {
            if (this.newPermitsThreshold == null || this.newPermitsThreshold <= 0) {
                return this.initialNrOfPermits / 2;
            }
            return this.newPermitsThreshold;
        }

        public void setNewPermitsThreshold(Integer newPermitsThreshold) {
            this.newPermitsThreshold = newPermitsThreshold;
        }
    }
}

