/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.DispatchInterceptors;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.PriorityRunnable;
import org.axonframework.axonserver.connector.TargetContextResolver;
import org.axonframework.axonserver.connector.command.AxonServerCommandDispatchException;
import org.axonframework.axonserver.connector.command.AxonServerRegistration;
import org.axonframework.axonserver.connector.command.CommandLoadFactorProvider;
import org.axonframework.axonserver.connector.command.CommandPriorityCalculator;
import org.axonframework.axonserver.connector.command.CommandSerializer;
import org.axonframework.axonserver.connector.util.ExecutorServiceBuilder;
import org.axonframework.axonserver.connector.util.ProcessingInstructionHelper;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.StringUtils;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.lifecycle.ShutdownLatch;
import org.axonframework.messaging.Distributed;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.serialization.Serializer;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerCommandBus
implements CommandBus,
Distributed<CommandBus>,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicLong TASK_SEQUENCE = new AtomicLong(Long.MIN_VALUE);
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final CommandBus localSegment;
    private final CommandSerializer serializer;
    private final RoutingStrategy routingStrategy;
    private final CommandPriorityCalculator priorityCalculator;
    private final CommandLoadFactorProvider loadFactorProvider;
    private final String context;
    private final DispatchInterceptors<CommandMessage<?>> dispatchInterceptors;
    private final TargetContextResolver<? super CommandMessage<?>> targetContextResolver;
    private final CommandCallback<Object, Object> defaultCommandCallback;
    private final ShutdownLatch shutdownLatch = new ShutdownLatch();
    private final ExecutorService executorService;
    private final SpanFactory spanFactory;

    public static Builder builder() {
        return new Builder();
    }

    public AxonServerCommandBus(Builder builder) {
        String c;
        builder.validate();
        this.axonServerConnectionManager = builder.axonServerConnectionManager;
        AxonServerConfiguration configuration = builder.configuration;
        this.localSegment = builder.localSegment;
        this.serializer = builder.buildSerializer();
        this.routingStrategy = builder.routingStrategy;
        this.priorityCalculator = builder.priorityCalculator;
        this.defaultCommandCallback = builder.defaultCommandCallback;
        this.loadFactorProvider = builder.loadFactorProvider;
        this.context = c = StringUtils.nonEmptyOrNull((String)builder.defaultContext) ? builder.defaultContext : configuration.getContext();
        this.targetContextResolver = builder.targetContextResolver.orElse(m -> c);
        this.executorService = (ExecutorService)builder.executorServiceBuilder.apply(builder.configuration, new PriorityBlockingQueue(1000));
        this.spanFactory = builder.spanFactory;
        this.dispatchInterceptors = new DispatchInterceptors();
    }

    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry handle) {
        handle.onStart(0x1FFFFFFF, this::start);
        handle.onShutdown(0x1FFFFFFF, this::disconnect);
        handle.onShutdown(0, this::shutdownDispatching);
    }

    public void start() {
        this.shutdownLatch.initialize();
    }

    public <C> void dispatch(@Nonnull CommandMessage<C> command) {
        this.dispatch(command, this.defaultCommandCallback);
    }

    public <C, R> void dispatch(@Nonnull CommandMessage<C> commandMessage, @Nonnull CommandCallback<? super C, ? super R> commandCallback) {
        logger.debug("Dispatch command [{}] with callback", (Object)commandMessage.getCommandName());
        this.doDispatch(this.dispatchInterceptors.intercept(commandMessage), commandCallback);
    }

    private <C, R> void doDispatch(CommandMessage<C> commandMessage, CommandCallback<? super C, ? super R> commandCallback) {
        Span span = this.spanFactory.createDispatchSpan(() -> "AxonServerCommandBus.dispatch", commandMessage, new Message[0]).start();
        SpanScope spanScope = span.makeCurrent();
        this.shutdownLatch.ifShuttingDown("Cannot dispatch new commands as this bus is being shutdown");
        ShutdownLatch.ActivityHandle commandInTransit = this.shutdownLatch.registerActivity();
        try {
            Command command = this.serializer.serialize((CommandMessage)this.spanFactory.propagateContext(commandMessage), this.routingStrategy.getRoutingKey(commandMessage), this.priorityCalculator.determinePriority(commandMessage));
            CompletableFuture result = this.axonServerConnectionManager.getConnection(this.targetContextResolver.resolveContext(commandMessage)).commandChannel().sendCommand(command);
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)result.thenApply(commandResponse -> this.serializer.deserialize((CommandResponse)commandResponse))).exceptionally(GenericCommandResultMessage::asCommandResultMessage)).thenAccept(r -> {
                if (r.isExceptional()) {
                    span.recordException(r.exceptionResult());
                }
                commandCallback.onResult(commandMessage, r);
            })).whenComplete((r, e) -> {
                commandInTransit.end();
                span.end();
            });
        }
        catch (Exception e2) {
            span.recordException((Throwable)e2).end();
            commandInTransit.end();
            AxonServerCommandDispatchException dispatchException = new AxonServerCommandDispatchException(ErrorCode.COMMAND_DISPATCH_ERROR.errorCode(), "Exception while dispatching a command to AxonServer", e2);
            commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)((Object)dispatchException)));
        }
        spanScope.close();
    }

    public Registration subscribe(@Nonnull String commandName, @Nonnull MessageHandler<? super CommandMessage<?>> messageHandler) {
        logger.debug("Subscribing command with name [{}] to this distributed CommandBus. Expect similar logging on the local segment.", (Object)commandName);
        Registration localRegistration = this.localSegment.subscribe(commandName, messageHandler);
        io.axoniq.axonserver.connector.Registration serverRegistration = this.axonServerConnectionManager.getConnection(this.context).commandChannel().registerCommandHandler(c -> {
            CompletableFuture<CommandResponse> result = new CompletableFuture<CommandResponse>();
            CommandProcessingTask processingTask = new CommandProcessingTask((Command)c, this.serializer, result, this.localSegment, this.spanFactory);
            long priority = ProcessingInstructionHelper.priority(c.getProcessingInstructionsList());
            long sequence = TASK_SEQUENCE.incrementAndGet();
            this.executorService.execute(new PriorityRunnable(processingTask, priority, sequence));
            return result;
        }, this.loadFactorProvider.getFor(commandName), new String[]{commandName});
        return new AxonServerRegistration(localRegistration, () -> ((io.axoniq.axonserver.connector.Registration)serverRegistration).cancel());
    }

    public CommandBus localSegment() {
        return this.localSegment;
    }

    public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return this.localSegment.registerHandlerInterceptor(handlerInterceptor);
    }

    public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        return this.dispatchInterceptors.registerDispatchInterceptor(dispatchInterceptor);
    }

    public CompletableFuture<Void> disconnect() {
        if (this.axonServerConnectionManager.isConnected(this.context)) {
            return this.axonServerConnectionManager.getConnection(this.context).commandChannel().prepareDisconnect();
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> shutdownDispatching() {
        return this.shutdownLatch.initiateShutdown();
    }

    public static class Builder {
        private CommandCallback<Object, Object> defaultCommandCallback = NoOpCallback.INSTANCE;
        private AxonServerConnectionManager axonServerConnectionManager;
        private AxonServerConfiguration configuration;
        private CommandBus localSegment;
        private Serializer serializer;
        private RoutingStrategy routingStrategy;
        private CommandPriorityCalculator priorityCalculator = CommandPriorityCalculator.defaultCommandPriorityCalculator();
        private ExecutorServiceBuilder executorServiceBuilder = ExecutorServiceBuilder.defaultCommandExecutorServiceBuilder();
        private CommandLoadFactorProvider loadFactorProvider = command -> 100;
        private String defaultContext;
        private TargetContextResolver<? super CommandMessage<?>> targetContextResolver = c -> StringUtils.nonEmptyOrNull((String)this.defaultContext) ? this.defaultContext : this.configuration.getContext();
        private SpanFactory spanFactory = NoOpSpanFactory.INSTANCE;

        public Builder axonServerConnectionManager(AxonServerConnectionManager axonServerConnectionManager) {
            BuilderUtils.assertNonNull((Object)axonServerConnectionManager, (String)"AxonServerConnectionManager may not be null");
            this.axonServerConnectionManager = axonServerConnectionManager;
            return this;
        }

        public Builder configuration(AxonServerConfiguration configuration) {
            BuilderUtils.assertNonNull((Object)configuration, (String)"AxonServerConfiguration may not be null");
            this.configuration = configuration;
            return this;
        }

        public Builder localSegment(CommandBus localSegment) {
            BuilderUtils.assertNonNull((Object)localSegment, (String)"Local CommandBus may not be null");
            this.localSegment = localSegment;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder routingStrategy(RoutingStrategy routingStrategy) {
            BuilderUtils.assertNonNull((Object)routingStrategy, (String)"RoutingStrategy may not be null");
            this.routingStrategy = routingStrategy;
            return this;
        }

        public Builder defaultCommandCallback(CommandCallback<Object, Object> defaultCommandCallback) {
            this.defaultCommandCallback = (CommandCallback)ObjectUtils.getOrDefault(defaultCommandCallback, (Object)NoOpCallback.INSTANCE);
            return this;
        }

        public Builder priorityCalculator(CommandPriorityCalculator priorityCalculator) {
            BuilderUtils.assertNonNull((Object)priorityCalculator, (String)"CommandPriorityCalculator may not be null");
            this.priorityCalculator = priorityCalculator;
            return this;
        }

        public Builder targetContextResolver(TargetContextResolver<? super CommandMessage<?>> targetContextResolver) {
            BuilderUtils.assertNonNull(targetContextResolver, (String)"TargetContextResolver may not be null");
            this.targetContextResolver = targetContextResolver;
            return this;
        }

        public Builder executorServiceBuilder(ExecutorServiceBuilder executorServiceBuilder) {
            BuilderUtils.assertNonNull((Object)executorServiceBuilder, (String)"ExecutorServiceBuilder may not be null");
            this.executorServiceBuilder = executorServiceBuilder;
            return this;
        }

        public Builder loadFactorProvider(CommandLoadFactorProvider loadFactorProvider) {
            BuilderUtils.assertNonNull((Object)loadFactorProvider, (String)"CommandLoadFactorProvider may not be null");
            this.loadFactorProvider = loadFactorProvider;
            return this;
        }

        public Builder defaultContext(String defaultContext) {
            BuilderUtils.assertNonEmpty((String)defaultContext, (String)"The context may not be null or empty");
            this.defaultContext = defaultContext;
            return this;
        }

        public Builder spanFactory(@Nonnull SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public AxonServerCommandBus build() {
            return new AxonServerCommandBus(this);
        }

        protected CommandSerializer buildSerializer() {
            return new CommandSerializer(this.serializer, this.configuration);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.axonServerConnectionManager, (String)"The AxonServerConnectionManager is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.configuration, (String)"The AxonServerConfiguration is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.localSegment, (String)"The Local CommandBus is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.serializer, (String)"The Serializer is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.routingStrategy, (String)"The RoutingStrategy is a hard requirement and should be provided");
        }
    }

    private static class CommandProcessingTask
    implements Runnable {
        private final CompletableFuture<CommandResponse> result;
        private final CommandBus localSegment;
        private final Command command;
        private final CommandSerializer serializer;
        private final SpanFactory spanFactory;

        public CommandProcessingTask(Command command, CommandSerializer serializer, CompletableFuture<CommandResponse> result, CommandBus localSegment, SpanFactory spanFactory) {
            this.command = command;
            this.serializer = serializer;
            this.result = result;
            this.localSegment = localSegment;
            this.spanFactory = spanFactory;
        }

        @Override
        public void run() {
            CommandMessage<?> deserializedCommand = this.serializer.deserialize(this.command);
            Span span = this.spanFactory.createChildHandlerSpan(() -> "AxonServerCommandBus.handle", deserializedCommand, new Message[0]);
            span.run(() -> {
                try {
                    this.localSegment.dispatch(deserializedCommand, (commandMessage, commandResultMessage) -> {
                        if (commandResultMessage.isExceptional()) {
                            span.recordException(commandResultMessage.exceptionResult());
                        }
                        this.result.complete(this.serializer.serialize(commandResultMessage, this.command.getMessageIdentifier()));
                    });
                }
                catch (Exception e) {
                    span.recordException((Throwable)e);
                    this.result.completeExceptionally(e);
                }
            });
        }
    }
}

