/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import java.util.Map;
import java.util.UUID;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.command.GrpcBackedCommandMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.common.AxonException;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class CommandSerializer {
    private final AxonServerConfiguration configuration;
    private final Serializer messageSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcObjectSerializer<Object> objectSerializer;

    public CommandSerializer(Serializer serializer, AxonServerConfiguration configuration) {
        this.configuration = configuration;
        this.messageSerializer = serializer;
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetaDataConverter(this.messageSerializer));
        this.payloadSerializer = new GrpcPayloadSerializer(this.messageSerializer);
        this.objectSerializer = new GrpcObjectSerializer(this.messageSerializer);
    }

    public Command serialize(CommandMessage<?> commandMessage, String routingKey, int priority) {
        return Command.newBuilder().setName(commandMessage.getCommandName()).setMessageIdentifier(commandMessage.getIdentifier()).setTimestamp(System.currentTimeMillis()).setPayload(this.payloadSerializer.apply((Message)commandMessage)).putAllMetaData(this.metadataSerializer.apply(commandMessage.getMetaData())).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.ROUTING_KEY).setValue(MetaDataValue.newBuilder().setTextValue(routingKey))).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.PRIORITY).setValue(MetaDataValue.newBuilder().setNumberValue((long)priority))).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
    }

    public CommandResponse serialize(CommandResultMessage<?> commandResultMessage, String requestIdentifier) {
        CommandResponse.Builder responseBuilder = CommandResponse.newBuilder().setMessageIdentifier((String)ObjectUtils.getOrDefault((Object)commandResultMessage.getIdentifier(), (Object)UUID.randomUUID().toString())).putAllMetaData(this.metadataSerializer.apply(commandResultMessage.getMetaData())).setRequestIdentifier(requestIdentifier);
        if (commandResultMessage.isExceptional()) {
            Throwable throwable = commandResultMessage.exceptionResult();
            responseBuilder.setErrorCode(ErrorCode.getCommandExecutionErrorCode(throwable).errorCode());
            responseBuilder.setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), throwable));
            commandResultMessage.exceptionDetails().ifPresent(details -> responseBuilder.setPayload(this.objectSerializer.apply(details)));
        } else if (commandResultMessage.getPayload() != null) {
            responseBuilder.setPayload(this.objectSerializer.apply(commandResultMessage.getPayload()));
        }
        return responseBuilder.build();
    }

    public CommandMessage<?> deserialize(Command command) {
        return new GrpcBackedCommandMessage(command, this.messageSerializer);
    }

    public <R> CommandResultMessage<R> deserialize(CommandResponse commandResponse) {
        MetaData metaData = new GrpcMetaDataConverter(this.messageSerializer).convert(commandResponse.getMetaDataMap());
        if (commandResponse.hasErrorMessage()) {
            Object exceptionDetails = commandResponse.hasPayload() ? this.messageSerializer.deserialize((SerializedObject)new GrpcSerializedObject(commandResponse.getPayload())) : null;
            AxonException exception = ErrorCode.getFromCode(commandResponse.getErrorCode()).convert(commandResponse.getErrorMessage(), () -> exceptionDetails);
            return new GenericCommandResultMessage((Message)new GenericMessage(commandResponse.getMessageIdentifier(), null, (Map)metaData), (Throwable)exception);
        }
        SerializedMessage response = commandResponse.hasPayload() ? new SerializedMessage(commandResponse.getMessageIdentifier(), new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(commandResponse.getPayload()), this.messageSerializer), new LazyDeserializingObject((Object)metaData)) : new GenericMessage(commandResponse.getMessageIdentifier(), Void.class, null, (Map)metaData);
        return new GenericCommandResultMessage((Message)response);
    }
}

