/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import org.axonframework.axonserver.connector.InstructionAckSource;

public class DefaultInstructionAckSource<T>
implements InstructionAckSource<T> {
    private final Function<InstructionAck, T> messageCreator;

    public DefaultInstructionAckSource(Function<InstructionAck, T> messageCreator) {
        this.messageCreator = messageCreator;
    }

    @Override
    public void sendAck(String instructionId, boolean success, ErrorMessage error, StreamObserver<T> stream) {
        if (instructionId == null || instructionId.equals("")) {
            return;
        }
        InstructionAck.Builder builder = InstructionAck.newBuilder().setInstructionId(instructionId).setSuccess(success);
        if (error != null) {
            builder.setError(error);
        }
        stream.onNext(this.messageCreator.apply(builder.build()));
    }
}

