/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.heartbeat;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.axonserver.connector.heartbeat.ConnectionSanityChecker;
import org.axonframework.axonserver.connector.util.Scheduler;
import org.axonframework.lifecycle.ShutdownHandler;
import org.axonframework.lifecycle.StartHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HeartbeatMonitor {
    private static final long DEFAULT_INITIAL_DELAY = 10000L;
    private static final long DEFAULT_DELAY = 1000L;
    private final Scheduler scheduler;
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private final Runnable onInvalidConnection;
    private final ConnectionSanityChecker connectionSanityCheck;
    private final long initialDelay;
    private final long delay;

    public HeartbeatMonitor(Runnable onInvalidConnection, ConnectionSanityChecker connectionSanityCheck, Scheduler scheduler, long initialDelay, long delay) {
        this.onInvalidConnection = onInvalidConnection;
        this.connectionSanityCheck = connectionSanityCheck;
        this.scheduler = scheduler;
        this.initialDelay = initialDelay;
        this.delay = delay;
    }

    private void run() {
        try {
            boolean valid = this.connectionSanityCheck.isValid();
            if (!valid) {
                this.onInvalidConnection.run();
            }
        }
        catch (Exception e) {
            logger.warn("Impossible to correctly monitor the Axon Server connection state.", (Throwable)e);
        }
    }

    @StartHandler(phase=0x40000009)
    public void start() {
        this.scheduler.scheduleWithFixedDelay(this::run, this.initialDelay, this.delay, TimeUnit.MILLISECONDS);
    }

    @ShutdownHandler(phase=0x40000009)
    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    private static final class DefaultScheduler
    implements Scheduler {
        private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

        private DefaultScheduler() {
        }

        @Override
        public Scheduler.ScheduledTask scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            ScheduledFuture<?> scheduled = this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            return scheduled::cancel;
        }

        @Override
        public void shutdownNow() {
            this.executor.shutdown();
        }
    }
}

