/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor;

import io.axoniq.axonserver.grpc.control.EventProcessorInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.TrackingToken;

public class TrackingEventProcessorInfoMessage {
    private static final String EVENT_PROCESSOR_MODE = "Tracking";

    public static EventProcessorInfo describe(TrackingEventProcessor eventProcessor) {
        List trackerInfo = eventProcessor.processingStatus().values().stream().map(TrackingEventProcessorInfoMessage::buildTrackerInfo).collect(Collectors.toList());
        return EventProcessorInfo.newBuilder().setProcessorName(eventProcessor.getName()).setTokenStoreIdentifier(eventProcessor.getTokenStoreIdentifier()).setMode(EVENT_PROCESSOR_MODE).setActiveThreads(eventProcessor.activeProcessorThreads()).setAvailableThreads(eventProcessor.availableProcessorThreads()).setRunning(eventProcessor.isRunning()).setError(eventProcessor.isError()).addAllSegmentStatus(trackerInfo).build();
    }

    private static EventProcessorInfo.SegmentStatus buildTrackerInfo(EventTrackerStatus status) {
        return EventProcessorInfo.SegmentStatus.newBuilder().setSegmentId(status.getSegment().getSegmentId()).setCaughtUp(status.isCaughtUp()).setReplaying(status.isReplaying()).setOnePartOf(status.getSegment().getMask() + 1).setTokenPosition(TrackingEventProcessorInfoMessage.getPosition(status.getTrackingToken())).setErrorState(status.isErrorState() ? TrackingEventProcessorInfoMessage.buildErrorMessage(status.getError()) : "").build();
    }

    private static long getPosition(TrackingToken trackingToken) {
        long position = 0L;
        if (trackingToken != null) {
            position = trackingToken.position().orElse(0L);
        }
        return position;
    }

    private static String buildErrorMessage(Throwable error) {
        return error.getClass().getName() + ": " + error.getMessage();
    }
}

