/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.heartbeat.connection.checker;

import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.heartbeat.ConnectionSanityChecker;
import org.axonframework.axonserver.connector.heartbeat.connection.checker.ActiveGrpcChannelChecker;

@Deprecated
public class HeartbeatConnectionChecker
implements ConnectionSanityChecker {
    private static final long DEFAULT_HEARTBEAT_TIMEOUT_MILLIS = 5000L;
    private final ConnectionSanityChecker delegate;
    private final long heartbeatTimeout;
    private final Clock clock;
    private final AtomicReference<Instant> lastReceivedHeartbeat = new AtomicReference();

    public HeartbeatConnectionChecker(AxonServerConnectionManager connectionManager, String context) {
        this((Runnable r) -> {}, new ActiveGrpcChannelChecker(connectionManager, context));
    }

    public HeartbeatConnectionChecker(Consumer<Runnable> registration, ConnectionSanityChecker delegate) {
        this(5000L, registration, delegate, Clock.systemUTC());
    }

    public HeartbeatConnectionChecker(long heartbeatTimeout, Consumer<Runnable> registerOnHeartbeat, ConnectionSanityChecker delegate, Clock clock) {
        this.clock = clock;
        this.delegate = delegate;
        this.heartbeatTimeout = heartbeatTimeout;
        registerOnHeartbeat.accept(this::onHeartbeat);
    }

    private void onHeartbeat() {
        this.lastReceivedHeartbeat.set(Instant.now(this.clock));
    }

    @Override
    public boolean isValid() {
        if (!this.delegate.isValid()) {
            return false;
        }
        Instant timeout = Instant.now(this.clock).minus(this.heartbeatTimeout, ChronoUnit.MILLIS);
        Instant instant = this.lastReceivedHeartbeat.get();
        return instant == null || !instant.isBefore(timeout);
    }
}

