/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.connector.AxonServerConnection;
import io.axoniq.axonserver.connector.AxonServerConnectionFactory;
import io.axoniq.axonserver.connector.impl.ContextConnection;
import io.axoniq.axonserver.connector.impl.ServerAddress;
import io.axoniq.axonserver.grpc.control.NodeInfo;
import io.grpc.Channel;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.lifecycle.ShutdownHandler;

public class AxonServerConnectionManager {
    private final Map<String, AxonServerConnection> connections = new ConcurrentHashMap<String, AxonServerConnection>();
    private final AxonServerConnectionFactory connectionFactory;
    private final String defaultContext;

    protected AxonServerConnectionManager(Builder builder, AxonServerConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.defaultContext = builder.axonServerConfiguration.getContext();
    }

    public static Builder builder() {
        return new Builder();
    }

    public AxonServerConnection getConnection() {
        return this.getConnection(this.getDefaultContext());
    }

    public AxonServerConnection getConnection(String context) {
        return this.connections.computeIfAbsent(context, arg_0 -> ((AxonServerConnectionFactory)this.connectionFactory).connect(arg_0));
    }

    public boolean isConnected(String context) {
        AxonServerConnection channel = this.connections.get(context);
        return channel != null && channel.isConnected();
    }

    @ShutdownHandler(phase=-134217728)
    public void shutdown() {
        this.connectionFactory.shutdown();
        this.disconnect();
    }

    public void disconnect(String context) {
        AxonServerConnection channel = this.connections.remove(context);
        if (channel != null) {
            channel.disconnect();
        }
    }

    public void disconnect() {
        this.connections.forEach((context, channel) -> channel.disconnect());
        this.connections.clear();
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    @Deprecated
    public Channel getChannel() {
        return ((ContextConnection)this.getConnection(this.defaultContext)).getManagedChannel();
    }

    @Deprecated
    public Channel getChannel(String context) {
        return ((ContextConnection)this.getConnection(context)).getManagedChannel();
    }

    public static class Builder {
        private AxonServerConfiguration axonServerConfiguration;
        private TagsConfiguration tagsConfiguration = new TagsConfiguration();

        public Builder axonServerConfiguration(AxonServerConfiguration axonServerConfiguration) {
            BuilderUtils.assertNonNull((Object)axonServerConfiguration, (String)"AxonServerConfiguration may not be null");
            this.axonServerConfiguration = axonServerConfiguration;
            return this;
        }

        public Builder tagsConfiguration(TagsConfiguration tagsConfiguration) {
            BuilderUtils.assertNonNull((Object)tagsConfiguration, (String)"TagsConfiguration may not be null");
            this.tagsConfiguration = tagsConfiguration;
            return this;
        }

        @Deprecated
        public Builder axonFrameworkVersionResolver(Supplier<String> axonFrameworkVersionResolver) {
            return this;
        }

        public AxonServerConnectionManager build() {
            this.validate();
            AxonServerConnectionFactory.Builder builder = AxonServerConnectionFactory.forClient((String)this.axonServerConfiguration.getComponentName(), (String)this.axonServerConfiguration.getClientId());
            List<NodeInfo> routingServers = this.axonServerConfiguration.routingServers();
            if (!routingServers.isEmpty()) {
                ServerAddress[] addresses = new ServerAddress[routingServers.size()];
                for (int i = 0; i < addresses.length; ++i) {
                    NodeInfo routingServer = routingServers.get(i);
                    addresses[i] = new ServerAddress(routingServer.getHostName(), routingServer.getGrpcPort());
                }
                builder.routingServers(addresses);
            }
            if (this.axonServerConfiguration.isSslEnabled()) {
                if (this.axonServerConfiguration.getCertFile() != null) {
                    try {
                        File certificateFile = new File(this.axonServerConfiguration.getCertFile());
                        builder.useTransportSecurity(SslContextBuilder.forClient().trustManager(certificateFile).build());
                    }
                    catch (SSLException e) {
                        throw new AxonConfigurationException("Exception configuring Transport Security", (Throwable)e);
                    }
                } else {
                    builder.useTransportSecurity();
                }
            }
            builder.connectTimeout(this.axonServerConfiguration.getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (this.axonServerConfiguration.getToken() != null) {
                builder.token(this.axonServerConfiguration.getToken());
            }
            this.tagsConfiguration.getTags().forEach((arg_0, arg_1) -> ((AxonServerConnectionFactory.Builder)builder).clientTag(arg_0, arg_1));
            AxonServerConnectionFactory connectionFactory = builder.build();
            return new AxonServerConnectionManager(this, connectionFactory);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.axonServerConfiguration, (String)"The AxonServerConfiguration is a hard requirement and should be provided");
        }
    }
}

