/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class ContextAddingInterceptor
implements ClientInterceptor {
    private static final Metadata.Key<String> CONTEXT_TOKEN_KEY = Metadata.Key.of((String)"AxonIQ-Context", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String token;

    public ContextAddingInterceptor(String token) {
        this.token = token;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (ContextAddingInterceptor.this.token != null) {
                    headers.put(CONTEXT_TOKEN_KEY, (Object)ContextAddingInterceptor.this.token);
                }
                super.start(responseListener, headers);
            }
        };
    }
}

