/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.util.MavenArtifactVersionResolver;

public class AxonFrameworkVersionResolver
implements Supplier<String> {
    private static final String ORG_AXONFRAMEWORK_GROUP_ID = "org.axonframework";
    private static final String AXON_SERVER_CONNECTOR_ARTIFACT_ID = "axon-server-connector";
    private static final String AXON_FRAMEWORK_VERSION_ENV_PROPERTY = "AXON_FRAMEWORK_VERSION";
    private static final String UNKNOWN_VERSION = "";
    private final Supplier<String> mavenAxonVersionSupplier;
    private final Function<String, String> envPropertySupplier;
    private final AtomicReference<String> version = new AtomicReference();

    public AxonFrameworkVersionResolver() {
        this(() -> {
            try {
                return new MavenArtifactVersionResolver(ORG_AXONFRAMEWORK_GROUP_ID, AXON_SERVER_CONNECTOR_ARTIFACT_ID, AxonFrameworkVersionResolver.class.getClassLoader()).get();
            }
            catch (IOException e) {
                throw new RuntimeException("Impossible to read maven artifact version for axon-server-connector");
            }
        }, System::getenv);
    }

    AxonFrameworkVersionResolver(Supplier<String> axonArtifactVersionSupplier, Function<String, String> envPropertySupplier) {
        this.mavenAxonVersionSupplier = axonArtifactVersionSupplier;
        this.envPropertySupplier = envPropertySupplier;
    }

    @Override
    public String get() {
        if (this.version.get() == null) {
            this.version.set(this.resolveVersion());
        }
        return this.version.get();
    }

    private String resolveVersion() {
        String version = this.mavenAxonVersionSupplier.get();
        if (version == null) {
            version = this.envPropertySupplier.apply(AXON_FRAMEWORK_VERSION_ENV_PROPERTY);
        }
        return version != null ? version : UNKNOWN_VERSION;
    }
}

