/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.heartbeat;

import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.heartbeat.HeartbeatMonitor;
import org.axonframework.axonserver.connector.heartbeat.source.GrpcHeartbeatSource;
import org.axonframework.config.Configuration;
import org.axonframework.config.ModuleConfiguration;

public class HeartbeatConfiguration
implements ModuleConfiguration {
    private final Function<Configuration, AxonServerConnectionManager> connectionManagerSupplier;
    private final Function<Configuration, AxonServerConfiguration> axonServerConfigurationSupplier;
    private final AtomicReference<HeartbeatMonitor> heartbeatMonitor = new AtomicReference();

    public HeartbeatConfiguration() {
        this(c -> (AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class), c -> (AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class));
    }

    public HeartbeatConfiguration(Function<Configuration, AxonServerConnectionManager> connectionManagerSupplier, Function<Configuration, AxonServerConfiguration> axonServerConfigurationSupplier) {
        this.connectionManagerSupplier = connectionManagerSupplier;
        this.axonServerConfigurationSupplier = axonServerConfigurationSupplier;
    }

    public void initialize(Configuration config) {
        AxonServerConnectionManager connectionManager = this.connectionManagerSupplier.apply(config);
        AxonServerConfiguration configuration = this.axonServerConfigurationSupplier.apply(config);
        String context = configuration.getContext();
        GrpcHeartbeatSource heartbeatSource = new GrpcHeartbeatSource(connectionManager, context);
        connectionManager.onOutboundInstruction(context, PlatformOutboundInstruction.RequestCase.HEARTBEAT, i -> heartbeatSource.pulse());
        this.heartbeatMonitor.set(new HeartbeatMonitor(connectionManager, context));
    }

    public void start() {
        this.heartbeatMonitor().start();
    }

    public void shutdown() {
        this.heartbeatMonitor().shutdown();
    }

    private HeartbeatMonitor heartbeatMonitor() {
        Supplier<RuntimeException> exceptionSupplier = () -> new IllegalStateException("HeartbeatConfiguration not initialized.");
        return Optional.ofNullable(this.heartbeatMonitor.get()).orElseThrow(exceptionSupplier);
    }
}

