/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.query.QueryRequest;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.util.GrpcMetaData;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class GrpcBackedQueryMessage<Q, R>
implements QueryMessage<Q, R> {
    private final QueryRequest query;
    private final LazyDeserializingObject<Q> serializedPayload;
    private final LazyDeserializingObject<ResponseType<R>> serializedResponseType;
    private final Supplier<MetaData> metaDataSupplier;

    public GrpcBackedQueryMessage(QueryRequest queryRequest, Serializer messageSerializer, Serializer serializer) {
        this(queryRequest, new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryRequest.getPayload()), messageSerializer), new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryRequest.getResponseType()), serializer), new GrpcMetaData(queryRequest.getMetaDataMap(), messageSerializer));
    }

    private GrpcBackedQueryMessage(QueryRequest queryRequest, LazyDeserializingObject<Q> serializedPayload, LazyDeserializingObject<ResponseType<R>> serializedResponseType, Supplier<MetaData> metaDataSupplier) {
        this.query = queryRequest;
        this.serializedPayload = serializedPayload;
        this.serializedResponseType = serializedResponseType;
        this.metaDataSupplier = metaDataSupplier;
    }

    public String getQueryName() {
        return this.query.getQuery();
    }

    public ResponseType<R> getResponseType() {
        return (ResponseType)this.serializedResponseType.getObject();
    }

    public String getIdentifier() {
        return this.query.getMessageIdentifier();
    }

    public MetaData getMetaData() {
        return this.metaDataSupplier.get();
    }

    public Q getPayload() {
        return (Q)this.serializedPayload.getObject();
    }

    public Class<Q> getPayloadType() {
        return this.serializedPayload.getType();
    }

    public GrpcBackedQueryMessage<Q, R> withMetaData(@Nonnull Map<String, ?> metaData) {
        return new GrpcBackedQueryMessage<Q, R>(this.query, this.serializedPayload, this.serializedResponseType, () -> MetaData.from((Map)metaData));
    }

    public GrpcBackedQueryMessage<Q, R> andMetaData(@Nonnull Map<String, ?> metaData) {
        return this.withMetaData((Map)this.getMetaData().mergedWith(metaData));
    }
}

