/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor.grpc;

import io.axoniq.axonserver.grpc.control.EventProcessorInfo;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.axonframework.axonserver.connector.processor.grpc.PlatformInboundMessage;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.TrackingEventProcessor;

public class TrackingEventProcessorInfoMessage
implements PlatformInboundMessage {
    private static final String EVENT_PROCESSOR_MODE = "Tracking";
    private final TrackingEventProcessor eventProcessor;

    TrackingEventProcessorInfoMessage(TrackingEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    @Override
    public PlatformInboundInstruction instruction() {
        List trackerInfo = this.eventProcessor.processingStatus().entrySet().stream().map(this::buildTrackerInfo).collect(Collectors.toList());
        EventProcessorInfo eventProcessorInfo = EventProcessorInfo.newBuilder().setProcessorName(this.eventProcessor.getName()).setMode(EVENT_PROCESSOR_MODE).setActiveThreads(this.eventProcessor.activeProcessorThreads()).setAvailableThreads(this.eventProcessor.availableProcessorThreads()).setRunning(this.eventProcessor.isRunning()).setError(this.eventProcessor.isError()).addAllEventTrackersInfo(trackerInfo).build();
        return PlatformInboundInstruction.newBuilder().setEventProcessorInfo(eventProcessorInfo).build();
    }

    private EventProcessorInfo.EventTrackerInfo buildTrackerInfo(Map.Entry<Integer, EventTrackerStatus> e) {
        return EventProcessorInfo.EventTrackerInfo.newBuilder().setSegmentId(e.getKey()).setCaughtUp(e.getValue().isCaughtUp()).setReplaying(e.getValue().isReplaying()).setOnePartOf(e.getValue().getSegment().getMask() + 1).build();
    }
}

