/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandProviderInbound;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.command.CommandSubscription;
import io.grpc.ClientInterceptor;
import io.grpc.stub.StreamObserver;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.DispatchInterceptors;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.command.AxonServerRegistration;
import org.axonframework.axonserver.connector.command.CommandPriorityCalculator;
import org.axonframework.axonserver.connector.command.CommandSerializer;
import org.axonframework.axonserver.connector.util.ContextAddingInterceptor;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.FlowControllingStreamObserver;
import org.axonframework.axonserver.connector.util.ProcessingInstructionHelper;
import org.axonframework.axonserver.connector.util.ResubscribableStreamObserver;
import org.axonframework.axonserver.connector.util.TokenAddingInterceptor;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerCommandBus
implements CommandBus {
    private static final Logger logger = LoggerFactory.getLogger(AxonServerCommandBus.class);
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final AxonServerConfiguration configuration;
    private final CommandBus localSegment;
    private final CommandSerializer serializer;
    private final RoutingStrategy routingStrategy;
    private final CommandPriorityCalculator priorityCalculator;
    private final CommandHandlerProvider commandHandlerProvider;
    private final ClientInterceptor[] interceptors;
    private final DispatchInterceptors<CommandMessage<?>> dispatchInterceptors;

    public AxonServerCommandBus(AxonServerConnectionManager axonServerConnectionManager, AxonServerConfiguration configuration, CommandBus localSegment, Serializer serializer, RoutingStrategy routingStrategy) {
        this(axonServerConnectionManager, configuration, localSegment, serializer, routingStrategy, CommandPriorityCalculator.defaultCommandPriorityCalculator());
    }

    public AxonServerCommandBus(AxonServerConnectionManager axonServerConnectionManager, AxonServerConfiguration configuration, CommandBus localSegment, Serializer serializer, RoutingStrategy routingStrategy, CommandPriorityCalculator priorityCalculator) {
        this.axonServerConnectionManager = axonServerConnectionManager;
        this.configuration = configuration;
        this.localSegment = localSegment;
        this.serializer = new CommandSerializer(serializer, configuration);
        this.routingStrategy = routingStrategy;
        this.priorityCalculator = priorityCalculator;
        this.commandHandlerProvider = new CommandHandlerProvider();
        this.interceptors = new ClientInterceptor[]{new TokenAddingInterceptor(configuration.getToken()), new ContextAddingInterceptor(configuration.getContext())};
        this.dispatchInterceptors = new DispatchInterceptors();
        this.axonServerConnectionManager.addReconnectListener(() -> this.commandHandlerProvider.resubscribe());
        this.axonServerConnectionManager.addDisconnectListener(() -> this.commandHandlerProvider.unsubscribeAll());
    }

    public <C> void dispatch(CommandMessage<C> command) {
        this.dispatch(command, (CommandCallback)NoOpCallback.INSTANCE);
    }

    public <C, R> void dispatch(CommandMessage<C> commandMessage, CommandCallback<? super C, ? super R> commandCallback) {
        logger.debug("Dispatch command [{}] with callback", (Object)commandMessage.getCommandName());
        this.doDispatch(this.dispatchInterceptors.intercept(commandMessage), commandCallback);
    }

    private <C, R> void doDispatch(final CommandMessage<C> commandMessage, final CommandCallback<? super C, ? super R> commandCallback) {
        final AtomicBoolean serverResponded = new AtomicBoolean(false);
        try {
            Command command = this.serializer.serialize(commandMessage, this.routingStrategy.getRoutingKey(commandMessage), this.priorityCalculator.determinePriority(commandMessage));
            ((CommandServiceGrpc.CommandServiceStub)CommandServiceGrpc.newStub(this.axonServerConnectionManager.getChannel()).withInterceptors(this.interceptors)).dispatch(command, new StreamObserver<CommandResponse>(){

                public void onNext(CommandResponse commandResponse) {
                    serverResponded.set(true);
                    logger.debug("Received command response [{}]", (Object)commandResponse);
                    try {
                        CommandResultMessage resultMessage = AxonServerCommandBus.this.serializer.deserialize(commandResponse);
                        commandCallback.onResult(commandMessage, resultMessage);
                    }
                    catch (Exception ex) {
                        commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ex));
                        logger.info("Failed to deserialize payload [{}] - Cause: {}", (Object)commandResponse.getPayload().getData(), (Object)ex.getCause().getMessage());
                    }
                }

                public void onError(Throwable throwable) {
                    serverResponded.set(true);
                    commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ErrorCode.COMMAND_DISPATCH_ERROR.convert(AxonServerCommandBus.this.configuration.getClientId(), throwable)));
                }

                public void onCompleted() {
                    if (!serverResponded.get()) {
                        ErrorMessage errorMessage = ErrorMessage.newBuilder().setMessage("No result from command executor").build();
                        commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ErrorCode.COMMAND_DISPATCH_ERROR.convert(errorMessage)));
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("There was a problem dispatching command [{}].", commandMessage, (Object)e);
            commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ErrorCode.COMMAND_DISPATCH_ERROR.convert(this.configuration.getClientId(), e)));
        }
    }

    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> messageHandler) {
        logger.debug("Subscribing command with name [{}]", (Object)commandName);
        this.commandHandlerProvider.subscribe(commandName);
        return new AxonServerRegistration(this.localSegment.subscribe(commandName, messageHandler), () -> this.commandHandlerProvider.unsubscribe(commandName));
    }

    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return this.localSegment.registerHandlerInterceptor(handlerInterceptor);
    }

    public void disconnect() {
        this.commandHandlerProvider.disconnect();
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        return this.dispatchInterceptors.registerDispatchInterceptor(dispatchInterceptor);
    }

    private class CommandHandlerProvider {
        private static final int COMMAND_QUEUE_CAPACITY = 1000;
        private static final int DEFAULT_PRIORITY = 0;
        private static final long THREAD_KEEP_ALIVE_TIME = 100L;
        private final CopyOnWriteArraySet<String> subscribedCommands = new CopyOnWriteArraySet();
        private final ExecutorService commandExecutor;
        private volatile boolean subscribing;
        private volatile boolean running = true;
        private volatile StreamObserver<CommandProviderOutbound> subscriberStreamObserver;

        CommandHandlerProvider() {
            PriorityBlockingQueue<Runnable> commandProcessQueue = new PriorityBlockingQueue<Runnable>(1000, Comparator.comparingLong(r -> r instanceof CommandProcessor ? ((CommandProcessor)r).getPriority() : 0L));
            Integer commandThreads = AxonServerCommandBus.this.configuration.getCommandThreads();
            this.commandExecutor = new ThreadPoolExecutor((int)commandThreads, (int)commandThreads, 100L, TimeUnit.MILLISECONDS, commandProcessQueue, (ThreadFactory)new AxonThreadFactory("AxonServerCommandReceiver"));
        }

        private void resubscribe() {
            if (this.subscribedCommands.isEmpty() || this.subscribing) {
                return;
            }
            try {
                StreamObserver<CommandProviderOutbound> outboundStreamObserver = this.getSubscriberObserver();
                this.subscribedCommands.forEach(command -> outboundStreamObserver.onNext((Object)CommandProviderOutbound.newBuilder().setSubscribe(CommandSubscription.newBuilder().setCommand((String)command).setComponentName(AxonServerCommandBus.this.configuration.getComponentName()).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setMessageId(UUID.randomUUID().toString()).build()).build()));
            }
            catch (Exception e) {
                logger.warn("Error while resubscribing - [{}]", (Object)e.getMessage());
            }
        }

        public void subscribe(String commandName) {
            this.subscribing = true;
            this.subscribedCommands.add(commandName);
            try {
                StreamObserver<CommandProviderOutbound> outboundStreamObserver = this.getSubscriberObserver();
                outboundStreamObserver.onNext((Object)CommandProviderOutbound.newBuilder().setSubscribe(CommandSubscription.newBuilder().setCommand(commandName).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setComponentName(AxonServerCommandBus.this.configuration.getComponentName()).setMessageId(UUID.randomUUID().toString()).build()).build());
            }
            catch (Exception e) {
                logger.debug("Subscribing command with name [{}] to Axon Server failed. Will resubscribe when connection is established.", (Object)commandName, (Object)e);
            }
            finally {
                this.subscribing = false;
            }
        }

        private void processCommand(Command command) {
            StreamObserver<CommandProviderOutbound> outboundStreamObserver = this.getSubscriberObserver();
            try {
                this.dispatchLocal(AxonServerCommandBus.this.serializer.deserialize(command), outboundStreamObserver);
            }
            catch (RuntimeException throwable) {
                logger.error("Error while dispatching command [{}] - Cause: {}", new Object[]{command.getName(), throwable.getMessage(), throwable});
                if (outboundStreamObserver == null) {
                    return;
                }
                CommandProviderOutbound response = CommandProviderOutbound.newBuilder().setCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(command.getMessageIdentifier()).setErrorCode(ErrorCode.COMMAND_DISPATCH_ERROR.errorCode()).setErrorMessage(ExceptionSerializer.serialize(AxonServerCommandBus.this.configuration.getClientId(), throwable))).build();
                outboundStreamObserver.onNext((Object)response);
            }
        }

        private synchronized StreamObserver<CommandProviderOutbound> getSubscriberObserver() {
            if (this.subscriberStreamObserver != null) {
                return this.subscriberStreamObserver;
            }
            StreamObserver<CommandProviderInbound> commandsFromRoutingServer = new StreamObserver<CommandProviderInbound>(){

                public void onNext(CommandProviderInbound commandToSubscriber) {
                    logger.debug("Received command from server: {}", (Object)commandToSubscriber);
                    if (commandToSubscriber.getRequestCase() == CommandProviderInbound.RequestCase.COMMAND) {
                        CommandHandlerProvider.this.commandExecutor.execute(new CommandProcessor(commandToSubscriber.getCommand()));
                    }
                }

                public void onError(Throwable ex) {
                    logger.warn("Received error from server: {}", (Object)ex.getMessage());
                    CommandHandlerProvider.this.subscriberStreamObserver = null;
                }

                public void onCompleted() {
                    logger.info("Received completed from server.");
                    CommandHandlerProvider.this.subscriberStreamObserver = null;
                }
            };
            ResubscribableStreamObserver<CommandProviderInbound> resubscribableStreamObserver = new ResubscribableStreamObserver<CommandProviderInbound>(commandsFromRoutingServer, t -> this.resubscribe());
            StreamObserver<CommandProviderOutbound> streamObserver = AxonServerCommandBus.this.axonServerConnectionManager.getCommandStream(resubscribableStreamObserver, AxonServerCommandBus.this.interceptors);
            logger.info("Creating new command stream subscriber");
            this.subscriberStreamObserver = new FlowControllingStreamObserver<CommandProviderOutbound>(streamObserver, AxonServerCommandBus.this.configuration, flowControl -> CommandProviderOutbound.newBuilder().setFlowControl((FlowControl)flowControl).build(), t -> t.getRequestCase().equals((Object)CommandProviderOutbound.RequestCase.COMMAND_RESPONSE)).sendInitialPermits();
            return this.subscriberStreamObserver;
        }

        public void unsubscribe(String command) {
            this.subscribedCommands.remove(command);
            try {
                this.getSubscriberObserver().onNext((Object)CommandProviderOutbound.newBuilder().setUnsubscribe(CommandSubscription.newBuilder().setCommand(command).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setMessageId(UUID.randomUUID().toString()).build()).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void unsubscribeAll() {
            for (String subscribedCommand : this.subscribedCommands) {
                try {
                    this.getSubscriberObserver().onNext((Object)CommandProviderOutbound.newBuilder().setUnsubscribe(CommandSubscription.newBuilder().setCommand(subscribedCommand).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setMessageId(UUID.randomUUID().toString()).build()).build());
                }
                catch (Exception exception) {}
            }
            this.subscriberStreamObserver = null;
        }

        private <C> void dispatchLocal(CommandMessage<C> command, StreamObserver<CommandProviderOutbound> responseObserver) {
            logger.debug("Dispatch command [{}] locally", (Object)command.getCommandName());
            AxonServerCommandBus.this.localSegment.dispatch(command, (commandMessage, commandResultMessage) -> {
                if (commandResultMessage.isExceptional()) {
                    Throwable throwable = commandResultMessage.exceptionResult();
                    CommandProviderOutbound response = CommandProviderOutbound.newBuilder().setCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(command.getIdentifier()).setErrorCode(throwable instanceof ConcurrencyException ? ErrorCode.CONCURRENCY_EXCEPTION.errorCode() : ErrorCode.COMMAND_EXECUTION_ERROR.errorCode()).setErrorMessage(ExceptionSerializer.serialize(AxonServerCommandBus.this.configuration.getClientId(), throwable))).build();
                    responseObserver.onNext((Object)response);
                    logger.info("Failed to dispatch command [{}] locally - Cause: {}", new Object[]{command.getCommandName(), throwable.getMessage(), throwable});
                } else {
                    logger.debug("Succeeded in dispatching command [{}] locally", (Object)command.getCommandName());
                    responseObserver.onNext((Object)AxonServerCommandBus.this.serializer.serialize(commandResultMessage, command.getIdentifier()));
                }
            });
        }

        void disconnect() {
            if (this.subscriberStreamObserver != null) {
                this.subscriberStreamObserver.onCompleted();
            }
            this.running = false;
            this.commandExecutor.shutdown();
        }

        private class CommandProcessor
        implements Runnable {
            private final long priority;
            private final Command command;

            private CommandProcessor(Command command) {
                this.priority = -ProcessingInstructionHelper.priority(command.getProcessingInstructionsList());
                this.command = command;
            }

            public long getPriority() {
                return this.priority;
            }

            @Override
            public void run() {
                if (!CommandHandlerProvider.this.running) {
                    logger.debug("Command Handler Provider has stopped running, hence command [{}] will no longer be processed");
                    return;
                }
                try {
                    logger.debug("Will process command: {}", (Object)this.command);
                    CommandHandlerProvider.this.processCommand(this.command);
                }
                catch (OutOfDirectMemoryError | RuntimeException e) {
                    logger.warn("Command Processor had an exception when processing command [{}]", (Object)this.command, (Object)e);
                }
            }
        }
    }
}

