/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.SerializedObject;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Serializer;

public class GrpcMetaDataConverter {
    private final Serializer serializer;

    public GrpcMetaDataConverter(Serializer serializer) {
        this.serializer = serializer;
    }

    public MetaDataValue convertToMetaDataValue(Object value) {
        MetaDataValue.Builder builder = MetaDataValue.newBuilder();
        if (value instanceof CharSequence) {
            builder.setTextValue(value.toString());
        } else if (value instanceof Double || value instanceof Float) {
            builder.setDoubleValue(((Number)value).doubleValue());
        } else if (value instanceof Number) {
            builder.setNumberValue(((Number)value).longValue());
        } else if (value instanceof Boolean) {
            builder.setBooleanValue((Boolean)value);
        } else {
            org.axonframework.serialization.SerializedObject serializedObject = this.serializer.serialize(value, byte[].class);
            builder.setBytesValue(SerializedObject.newBuilder().setType(serializedObject.getType().getName()).setData(ByteString.copyFrom((byte[])((byte[])serializedObject.getData()))).setRevision((String)ObjectUtils.getOrDefault((Object)serializedObject.getType().getRevision(), (Object)"")).build());
        }
        return builder.build();
    }

    public MetaData convert(Map<String, MetaDataValue> metaDataMap) {
        if (metaDataMap.isEmpty()) {
            return MetaData.emptyInstance();
        }
        HashMap metaData = new HashMap(metaDataMap.size());
        metaDataMap.forEach((k, v) -> metaData.put(k, this.convertFromMetaDataValue((MetaDataValue)v)));
        return MetaData.from(metaData);
    }

    public Object convertFromMetaDataValue(MetaDataValue value) {
        switch (value.getDataCase()) {
            case TEXT_VALUE: {
                return value.getTextValue();
            }
            case BYTES_VALUE: {
                return this.serializer.deserialize((org.axonframework.serialization.SerializedObject)new GrpcSerializedObject(value.getBytesValue()));
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case BOOLEAN_VALUE: {
                return value.getBooleanValue();
            }
        }
        return null;
    }
}

