/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueBackedSpliterator<R>
implements Spliterator<R> {
    private static final Logger logger = LoggerFactory.getLogger(QueueBackedSpliterator.class);
    private final long myTimeOut;
    private final BlockingQueue<WrappedElement<R>> blockingQueue = new LinkedBlockingQueue<WrappedElement<R>>();

    public QueueBackedSpliterator(long timeout, TimeUnit timeUnit) {
        this.myTimeOut = System.currentTimeMillis() + timeUnit.toMillis(timeout);
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        WrappedElement<R> element = null;
        try {
            long remaining = this.myTimeOut - System.currentTimeMillis();
            if (remaining > 0L && (element = this.blockingQueue.poll(this.myTimeOut - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) != null) {
                if (((WrappedElement)element).stop) {
                    return false;
                }
                if (((WrappedElement)element).wrapped != null) {
                    action.accept(((WrappedElement)element).wrapped);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted tryAdvance", (Throwable)e);
            return false;
        }
        return element != null;
    }

    @Override
    public Spliterator<R> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return 0L;
    }

    @Override
    public int characteristics() {
        return 0;
    }

    public void put(R object) {
        try {
            this.blockingQueue.put(new WrappedElement<R>(object));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted put", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void cancel(Throwable t) {
        try {
            this.blockingQueue.put(new WrappedElement(true, t));
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted cancel", (Throwable)e);
        }
    }

    class WrappedElement<W> {
        private final W wrapped;
        private final boolean stop;
        private final Throwable exception;

        WrappedElement(W wrapped) {
            this.wrapped = wrapped;
            this.stop = false;
            this.exception = null;
        }

        WrappedElement(boolean stop, Throwable exception) {
            this.wrapped = null;
            this.stop = stop;
            this.exception = exception;
        }
    }
}

