/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.query.QueryResponse;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.util.GrpcMetadata;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.MetaData;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class GrpcBackedResponseMessage<R>
implements QueryResponseMessage<R> {
    private final QueryResponse queryResponse;
    private final Serializer messageSerializer;
    private final LazyDeserializingObject<R> serializedPayload;
    private final Throwable exception;
    private final Supplier<MetaData> metadata;

    public GrpcBackedResponseMessage(QueryResponse queryResponse, Serializer messageSerializer) {
        this.queryResponse = queryResponse;
        this.messageSerializer = messageSerializer;
        this.metadata = new GrpcMetadata(queryResponse.getMetaDataMap(), messageSerializer);
        this.exception = queryResponse.hasErrorMessage() ? ErrorCode.getFromCode(queryResponse.getErrorCode()).convert(queryResponse.getErrorMessage()) : null;
        this.serializedPayload = queryResponse.hasPayload() && !"empty".equalsIgnoreCase(queryResponse.getPayload().getType()) ? new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryResponse.getPayload()), messageSerializer) : null;
    }

    private GrpcBackedResponseMessage(QueryResponse queryResponse, Serializer messageSerializer, LazyDeserializingObject<R> serializedPayload, Throwable exception, Supplier<MetaData> metadata) {
        this.queryResponse = queryResponse;
        this.messageSerializer = messageSerializer;
        this.serializedPayload = serializedPayload;
        this.exception = exception;
        this.metadata = metadata;
    }

    public String getIdentifier() {
        return this.queryResponse.getMessageIdentifier();
    }

    public MetaData getMetaData() {
        return this.metadata.get();
    }

    public R getPayload() {
        if (this.serializedPayload == null) {
            return null;
        }
        return (R)this.serializedPayload.getObject();
    }

    public Class<R> getPayloadType() {
        if (this.serializedPayload == null) {
            return null;
        }
        return this.serializedPayload.getType();
    }

    public boolean isExceptional() {
        return this.exception != null;
    }

    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    public GrpcBackedResponseMessage<R> withMetaData(Map<String, ?> metaData) {
        return new GrpcBackedResponseMessage<R>(this.queryResponse, this.messageSerializer, this.serializedPayload, this.exception, () -> MetaData.from((Map)metaData));
    }

    public QueryResponseMessage<R> andMetaData(Map<String, ?> var1) {
        return this.withMetaData((Map)this.getMetaData().mergedWith(var1));
    }
}

