/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.command.Command;
import java.util.Map;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public class GrpcBackedCommandMessage<C>
implements CommandMessage<C> {
    private final Command request;
    private final Serializer serializer;
    private MetaData metaData;

    public GrpcBackedCommandMessage(Command request, Serializer serializer) {
        this.request = request;
        this.serializer = serializer;
    }

    public String getCommandName() {
        return this.request.getName();
    }

    public String getIdentifier() {
        return this.request.getMessageIdentifier();
    }

    public MetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = this.deserializeMetaData(this.request.getMetaDataMap());
        }
        return this.metaData;
    }

    public C getPayload() {
        String revision = this.request.getPayload().getRevision();
        SimpleSerializedObject object = new SimpleSerializedObject((Object)this.request.getPayload().getData().toByteArray(), byte[].class, this.request.getPayload().getType(), "".equals(revision) ? null : revision);
        return (C)this.serializer.deserialize((SerializedObject)object);
    }

    public Class<C> getPayloadType() {
        try {
            return Class.forName(this.request.getPayload().getType());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public CommandMessage<C> withMetaData(Map<String, ?> map) {
        return this;
    }

    public CommandMessage<C> andMetaData(Map<String, ?> map) {
        return this;
    }

    private MetaData deserializeMetaData(Map<String, MetaDataValue> metaDataMap) {
        if (metaDataMap.isEmpty()) {
            return MetaData.emptyInstance();
        }
        GrpcMetaDataConverter grpcMetaDataConverter = new GrpcMetaDataConverter(this.serializer);
        return MetaData.from((Map)grpcMetaDataConverter.convert(metaDataMap));
    }
}

