/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query.subscription;

import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.QueryUpdateComplete;
import io.axoniq.axonserver.grpc.query.QueryUpdateCompleteExceptionally;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryResponse;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.GrpcBackedResponseMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedQueryUpdateMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedSubscriptionQueryMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Serializer;

public class SubscriptionMessageSerializer {
    private final AxonServerConfiguration conf;
    private final Serializer messageSerializer;
    private final Serializer genericSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcObjectSerializer<Object> responseTypeSerializer;

    public SubscriptionMessageSerializer(AxonServerConfiguration conf, Serializer messageSerializer, Serializer genericSerializer) {
        this.conf = conf;
        this.messageSerializer = messageSerializer;
        this.genericSerializer = genericSerializer;
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetaDataConverter(messageSerializer));
        this.payloadSerializer = new GrpcPayloadSerializer(messageSerializer);
        this.responseTypeSerializer = new GrpcObjectSerializer(genericSerializer);
    }

    QueryProviderOutbound serialize(QueryResponseMessage initialResult, String subscriptionId) {
        QueryResponse response = QueryResponse.newBuilder().setPayload(this.payloadSerializer.apply((Message)initialResult)).putAllMetaData(this.metadataSerializer.apply(initialResult.getMetaData())).setMessageIdentifier(initialResult.getIdentifier()).setRequestIdentifier(subscriptionId).build();
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setInitialResult(response)).build();
    }

    <I> QueryResponseMessage<I> deserialize(QueryResponse queryResponse) {
        return new GrpcBackedResponseMessage(queryResponse, this.messageSerializer);
    }

    QueryProviderOutbound serialize(SubscriptionQueryUpdateMessage<?> update, String subscriptionId) {
        QueryUpdate.Builder builder = QueryUpdate.newBuilder().setPayload(this.payloadSerializer.apply((Message)update)).putAllMetaData(this.metadataSerializer.apply(update.getMetaData())).setMessageIdentifier(update.getIdentifier()).setClientId(this.conf.getClientId()).setComponentName(this.conf.getComponentName());
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setUpdate(builder.build())).build();
    }

    <U> SubscriptionQueryUpdateMessage<U> deserialize(QueryUpdate queryUpdate) {
        return new GrpcBackedQueryUpdateMessage(queryUpdate, this.messageSerializer);
    }

    QueryProviderOutbound serializeCompleteExceptionally(String subscriptionId, Throwable cause) {
        QueryUpdateCompleteExceptionally.Builder builder = QueryUpdateCompleteExceptionally.newBuilder().setErrorMessage(ExceptionSerializer.serialize(this.conf.getClientId(), cause)).setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode()).setClientId(this.conf.getClientId()).setComponentName(this.conf.getComponentName());
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setCompleteExceptionally(builder.build())).build();
    }

    public SubscriptionQuery serialize(SubscriptionQueryMessage message) {
        QueryRequest queryRequest = QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(message.getIdentifier()).setQuery(message.getQueryName()).setClientId(this.conf.getClientId()).setComponentName(this.conf.getComponentName()).setPayload(this.payloadSerializer.apply((Message)message)).setResponseType((SerializedObject)this.responseTypeSerializer.apply((Object)message.getResponseType())).putAllMetaData(this.metadataSerializer.apply(message.getMetaData())).build();
        SubscriptionQuery.Builder builder = SubscriptionQuery.newBuilder().setSubscriptionIdentifier(message.getIdentifier()).setNumberOfPermits(this.conf.getInitialNrOfPermits().intValue()).setUpdateResponseType((SerializedObject)this.responseTypeSerializer.apply((Object)message.getUpdateResponseType())).setQueryRequest(queryRequest);
        return builder.build();
    }

    <Q, I, U> SubscriptionQueryMessage<Q, I, U> deserialize(SubscriptionQuery query) {
        return new GrpcBackedSubscriptionQueryMessage(query, this.messageSerializer, this.genericSerializer);
    }

    QueryProviderOutbound serializeComplete(String subscriptionId) {
        QueryUpdateComplete.Builder builder = QueryUpdateComplete.newBuilder().setClientId(this.conf.getClientId()).setComponentName(this.conf.getComponentName());
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setComplete(builder.build())).build();
    }
}

