/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.query.QueryComplete;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryServiceGrpc;
import io.axoniq.axonserver.grpc.query.QuerySubscription;
import io.grpc.ClientInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.DispatchInterceptors;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.command.AxonServerRegistration;
import org.axonframework.axonserver.connector.query.QueryPriorityCalculator;
import org.axonframework.axonserver.connector.query.QuerySerializer;
import org.axonframework.axonserver.connector.query.QueueBackedSpliterator;
import org.axonframework.axonserver.connector.query.RemoteQueryException;
import org.axonframework.axonserver.connector.query.subscription.AxonServerSubscriptionQueryResult;
import org.axonframework.axonserver.connector.query.subscription.DeserializedResult;
import org.axonframework.axonserver.connector.query.subscription.SubscriptionMessageSerializer;
import org.axonframework.axonserver.connector.query.subscription.SubscriptionQueryRequestTarget;
import org.axonframework.axonserver.connector.util.ContextAddingInterceptor;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.FlowControllingStreamObserver;
import org.axonframework.axonserver.connector.util.ProcessingInstructionHelper;
import org.axonframework.axonserver.connector.util.TokenAddingInterceptor;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerQueryBus
implements QueryBus {
    private final Logger logger = LoggerFactory.getLogger(AxonServerQueryBus.class);
    private final AxonServerConfiguration configuration;
    private final QueryUpdateEmitter updateEmitter;
    private final QueryBus localSegment;
    private final QuerySerializer serializer;
    private final SubscriptionMessageSerializer subscriptionSerializer;
    private final QueryPriorityCalculator priorityCalculator;
    private final QueryProvider queryProvider;
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final ClientInterceptor[] interceptors;
    private final Collection<String> subscriptions = new CopyOnWriteArraySet<String>();
    private final DispatchInterceptors<QueryMessage<?, ?>> dispatchInterceptors = new DispatchInterceptors();
    private final Map<QueryProviderInbound.RequestCase, Collection<Consumer<QueryProviderInbound>>> queryHandlers = new EnumMap<QueryProviderInbound.RequestCase, Collection<Consumer<QueryProviderInbound>>>(QueryProviderInbound.RequestCase.class);

    public AxonServerQueryBus(AxonServerConnectionManager axonServerConnectionManager, AxonServerConfiguration configuration, QueryUpdateEmitter updateEmitter, QueryBus localSegment, Serializer messageSerializer, Serializer genericSerializer, QueryPriorityCalculator priorityCalculator) {
        this.configuration = configuration;
        this.updateEmitter = updateEmitter;
        this.localSegment = localSegment;
        this.serializer = new QuerySerializer(messageSerializer, genericSerializer, configuration);
        this.priorityCalculator = priorityCalculator;
        this.queryProvider = new QueryProvider();
        this.axonServerConnectionManager = axonServerConnectionManager;
        this.axonServerConnectionManager.addReconnectListener(() -> this.queryProvider.resubscribe());
        this.axonServerConnectionManager.addDisconnectListener(() -> this.queryProvider.unsubscribeAll());
        this.interceptors = new ClientInterceptor[]{new TokenAddingInterceptor(configuration.getToken()), new ContextAddingInterceptor(configuration.getContext())};
        this.subscriptionSerializer = new SubscriptionMessageSerializer(configuration, messageSerializer, genericSerializer);
        axonServerConnectionManager.addDisconnectListener(this::onApplicationDisconnected);
        axonServerConnectionManager.addReconnectInterceptor(this::interceptReconnectRequest);
        SubscriptionQueryRequestTarget target = new SubscriptionQueryRequestTarget(localSegment, this::publish, this.subscriptionSerializer);
        this.on(QueryProviderInbound.RequestCase.SUBSCRIPTION_QUERY_REQUEST, target::onSubscriptionQueryRequest);
        axonServerConnectionManager.addDisconnectListener(target::onApplicationDisconnected);
    }

    public <R> Registration subscribe(String queryName, Type responseType, MessageHandler<? super QueryMessage<?, R>> handler) {
        return new AxonServerRegistration(this.queryProvider.subscribe(queryName, responseType, this.configuration.getComponentName(), handler), () -> this.queryProvider.unsubscribe(queryName, responseType, this.configuration.getComponentName()));
    }

    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(QueryMessage<Q, R> queryMessage) {
        QueryMessage<Q, R> interceptedQuery = this.dispatchInterceptors.intercept(queryMessage);
        final CompletableFuture<QueryResponseMessage<R>> completableFuture = new CompletableFuture<QueryResponseMessage<R>>();
        this.queryServiceStub().query(this.serializer.serializeRequest(interceptedQuery, 1, TimeUnit.HOURS.toMillis(1L), this.priorityCalculator.determinePriority(interceptedQuery)), new StreamObserver<QueryResponse>(){

            public void onNext(QueryResponse queryResponse) {
                AxonServerQueryBus.this.logger.debug("Received response: {}", (Object)queryResponse);
                if (queryResponse.hasMessage()) {
                    completableFuture.completeExceptionally((Throwable)((Object)new RemoteQueryException(queryResponse.getErrorCode(), queryResponse.getMessage())));
                } else {
                    completableFuture.complete(AxonServerQueryBus.this.serializer.deserializeResponse(queryResponse));
                }
            }

            public void onError(Throwable throwable) {
                AxonServerQueryBus.this.logger.warn("Received error while waiting for first response: {}", (Object)throwable.getMessage(), (Object)throwable);
                completableFuture.completeExceptionally(throwable);
            }

            public void onCompleted() {
                if (!completableFuture.isDone()) {
                    completableFuture.completeExceptionally((Throwable)((Object)new RemoteQueryException(ErrorCode.OTHER.errorCode(), ErrorMessage.newBuilder().setMessage("No result from query executor").build())));
                }
            }
        });
        return completableFuture;
    }

    public QueryServiceGrpc.QueryServiceStub queryServiceStub() {
        return (QueryServiceGrpc.QueryServiceStub)QueryServiceGrpc.newStub(this.axonServerConnectionManager.getChannel()).withInterceptors(this.interceptors);
    }

    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(QueryMessage<Q, R> queryMessage, long timeout, TimeUnit timeUnit) {
        QueryMessage<Q, R> interceptedQuery = this.dispatchInterceptors.intercept(queryMessage);
        final QueueBackedSpliterator resultSpliterator = new QueueBackedSpliterator(timeout, timeUnit);
        ((QueryServiceGrpc.QueryServiceStub)this.queryServiceStub().withDeadlineAfter(timeout, timeUnit)).query(this.serializer.serializeRequest(interceptedQuery, -1, timeUnit.toMillis(timeout), this.priorityCalculator.determinePriority(interceptedQuery)), new StreamObserver<QueryResponse>(){

            public void onNext(QueryResponse queryResponse) {
                AxonServerQueryBus.this.logger.debug("Received response: {}", (Object)queryResponse);
                if (queryResponse.hasMessage()) {
                    AxonServerQueryBus.this.logger.warn("Received exception: {}", (Object)queryResponse.getMessage());
                } else {
                    resultSpliterator.put(AxonServerQueryBus.this.serializer.deserializeResponse(queryResponse));
                }
            }

            public void onError(Throwable throwable) {
                if (!AxonServerQueryBus.this.isDeadlineExceeded(throwable)) {
                    AxonServerQueryBus.this.logger.warn("Received error while waiting for responses: {}", (Object)throwable.getMessage(), (Object)throwable);
                }
                resultSpliterator.cancel(throwable);
            }

            public void onCompleted() {
                resultSpliterator.cancel(null);
            }
        });
        return StreamSupport.stream(resultSpliterator, false);
    }

    private boolean isDeadlineExceeded(Throwable throwable) {
        return throwable instanceof StatusRuntimeException && ((StatusRuntimeException)throwable).getStatus().getCode().equals((Object)Status.Code.DEADLINE_EXCEEDED);
    }

    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super QueryMessage<?, ?>> interceptor) {
        return this.localSegment.registerHandlerInterceptor(interceptor);
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super QueryMessage<?, ?>> dispatchInterceptor) {
        return this.dispatchInterceptors.registerDispatchInterceptor(dispatchInterceptor);
    }

    public void disconnect() {
        this.queryProvider.disconnect();
    }

    public void publish(QueryProviderOutbound providerOutbound) {
        this.queryProvider.getSubscriberObserver().onNext((Object)providerOutbound);
    }

    public void on(QueryProviderInbound.RequestCase requestCase, Consumer<QueryProviderInbound> consumer) {
        Collection consumers = this.queryHandlers.computeIfAbsent(requestCase, rc -> new CopyOnWriteArraySet());
        consumers.add(consumer);
    }

    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(SubscriptionQueryMessage<Q, I, U> query, SubscriptionQueryBackpressure backPressure, int updateBufferSize) {
        String subscriptionId = query.getIdentifier();
        if (this.subscriptions.contains(subscriptionId)) {
            String errorMessage = "Already exists a subscription query with the same subscriptionId: " + subscriptionId;
            this.logger.warn(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.logger.debug("Subscription Query requested with subscriptionId {}", (Object)subscriptionId);
        this.subscriptions.add(subscriptionId);
        QueryServiceGrpc.QueryServiceStub queryService = this.queryServiceStub();
        AxonServerSubscriptionQueryResult result = new AxonServerSubscriptionQueryResult(this.subscriptionSerializer.serialize(query), queryService::subscription, this.configuration, backPressure, updateBufferSize, () -> this.subscriptions.remove(subscriptionId));
        return new DeserializedResult(result.get(), this.subscriptionSerializer);
    }

    public QueryUpdateEmitter queryUpdateEmitter() {
        return this.updateEmitter;
    }

    private Runnable interceptReconnectRequest(Runnable reconnect) {
        if (this.subscriptions.isEmpty()) {
            return reconnect;
        }
        return () -> this.logger.info("Reconnect refused because there are active subscription queries.");
    }

    private void onApplicationDisconnected() {
        this.subscriptions.clear();
    }

    class QueryProvider {
        private final ConcurrentMap<QueryDefinition, Set<MessageHandler<? super QueryMessage<?, ?>>>> subscribedQueries = new ConcurrentHashMap();
        private final PriorityBlockingQueue<QueryRequest> queryQueue;
        private final ExecutorService executor = Executors.newFixedThreadPool(AxonServerQueryBus.access$300(AxonServerQueryBus.this).getQueryThreads());
        private StreamObserver<QueryProviderOutbound> outboundStreamObserver;
        private volatile boolean subscribing;

        QueryProvider() {
            this.queryQueue = new PriorityBlockingQueue<QueryRequest>(1000, Comparator.comparingLong(c -> -ProcessingInstructionHelper.priority(c.getProcessingInstructionsList())));
            IntStream.range(0, AxonServerQueryBus.this.configuration.getQueryThreads()).forEach(i -> this.executor.submit(this::queryExecutor));
        }

        private void queryExecutor() {
            AxonServerQueryBus.this.logger.debug("Starting Query Executor");
            boolean interrupted = false;
            while (!interrupted) {
                try {
                    QueryRequest query = this.queryQueue.poll(10L, TimeUnit.SECONDS);
                    if (query == null) continue;
                    AxonServerQueryBus.this.logger.debug("Received query: {}", (Object)query);
                    this.processQuery(query);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    AxonServerQueryBus.this.logger.warn("Interrupted queryExecutor", (Throwable)e);
                    interrupted = true;
                }
            }
        }

        private void processQuery(QueryRequest query) {
            String requestId = query.getMessageIdentifier();
            try {
                if (ProcessingInstructionHelper.numberOfResults(query.getProcessingInstructionsList()) == 1L) {
                    QueryResponseMessage response2 = (QueryResponseMessage)AxonServerQueryBus.this.localSegment.query(AxonServerQueryBus.this.serializer.deserializeRequest(query)).get();
                    this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryResponse(AxonServerQueryBus.this.serializer.serializeResponse(response2, requestId)).build());
                } else {
                    AxonServerQueryBus.this.localSegment.scatterGather(AxonServerQueryBus.this.serializer.deserializeRequest(query), 0L, TimeUnit.SECONDS).forEach(response -> this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryResponse(AxonServerQueryBus.this.serializer.serializeResponse((QueryResponseMessage<?>)response, requestId)).build()));
                }
                this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryComplete(QueryComplete.newBuilder().setMessageId(UUID.randomUUID().toString()).setRequestId(requestId)).build());
            }
            catch (Exception ex) {
                AxonServerQueryBus.this.logger.warn("Received error from localSegment: {}", (Object)ex.getMessage(), (Object)ex);
                this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryResponse(QueryResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(requestId).setMessage(ExceptionSerializer.serialize(AxonServerQueryBus.this.configuration.getClientName(), ex)).setErrorCode(ErrorCode.resolve(ex).errorCode()).build()).build());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> Registration subscribe(String queryName, Type responseType, String componentName, MessageHandler<? super QueryMessage<?, R>> handler) {
            this.subscribing = true;
            Set registrations = this.subscribedQueries.computeIfAbsent(new QueryDefinition(queryName, responseType.getTypeName(), componentName), k -> new CopyOnWriteArraySet());
            registrations.add(handler);
            try {
                this.getSubscriberObserver().onNext((Object)QueryProviderOutbound.newBuilder().setSubscribe(QuerySubscription.newBuilder().setMessageId(UUID.randomUUID().toString()).setClientName(AxonServerQueryBus.this.configuration.getClientName()).setComponentName(componentName).setQuery(queryName).setResultName(responseType.getTypeName()).setNrOfHandlers(registrations.size()).build()).build());
            }
            catch (Exception ex) {
                AxonServerQueryBus.this.logger.warn("Subscribe failed - {}", (Object)ex.getMessage());
            }
            finally {
                this.subscribing = false;
            }
            return AxonServerQueryBus.this.localSegment.subscribe(queryName, responseType, handler);
        }

        private synchronized StreamObserver<QueryProviderOutbound> getSubscriberObserver() {
            if (this.outboundStreamObserver == null) {
                AxonServerQueryBus.this.logger.info("Create new subscriber");
                StreamObserver<QueryProviderInbound> queryProviderInboundStreamObserver = new StreamObserver<QueryProviderInbound>(){

                    public void onNext(QueryProviderInbound inboundRequest) {
                        QueryProviderInbound.RequestCase requestCase = inboundRequest.getRequestCase();
                        ((Collection)AxonServerQueryBus.this.queryHandlers.getOrDefault((Object)requestCase, Collections.emptySet())).forEach(consumer -> consumer.accept(inboundRequest));
                        switch (requestCase) {
                            case CONFIRMATION: {
                                break;
                            }
                            case QUERY: {
                                QueryProvider.this.queryQueue.add(inboundRequest.getQuery());
                            }
                        }
                    }

                    public void onError(Throwable ex) {
                        AxonServerQueryBus.this.logger.warn("Received error from server: {}", (Object)ex.getMessage());
                        QueryProvider.this.outboundStreamObserver = null;
                        if (ex instanceof StatusRuntimeException && ((StatusRuntimeException)ex).getStatus().getCode().equals((Object)Status.UNAVAILABLE.getCode())) {
                            return;
                        }
                        QueryProvider.this.resubscribe();
                    }

                    public void onCompleted() {
                        AxonServerQueryBus.this.logger.debug("Received completed from server");
                        QueryProvider.this.outboundStreamObserver = null;
                    }
                };
                StreamObserver<QueryProviderOutbound> stream = AxonServerQueryBus.this.axonServerConnectionManager.getQueryStream(queryProviderInboundStreamObserver, AxonServerQueryBus.this.interceptors);
                this.outboundStreamObserver = new FlowControllingStreamObserver<QueryProviderOutbound>(stream, AxonServerQueryBus.this.configuration, flowControl -> QueryProviderOutbound.newBuilder().setFlowControl((FlowControl)flowControl).build(), t -> t.getRequestCase().equals((Object)QueryProviderOutbound.RequestCase.QUERYRESPONSE)).sendInitialPermits();
            }
            return this.outboundStreamObserver;
        }

        public void unsubscribe(String queryName, Type responseType, String componentName) {
            QueryDefinition queryDefinition = new QueryDefinition(queryName, responseType.getTypeName(), componentName);
            this.subscribedQueries.remove(queryDefinition);
            try {
                this.getSubscriberObserver().onNext((Object)QueryProviderOutbound.newBuilder().setUnsubscribe(this.subscriptionBuilder(queryDefinition, 1)).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void unsubscribeAll() {
            this.subscribedQueries.forEach((d, count) -> {
                try {
                    this.getSubscriberObserver().onNext((Object)QueryProviderOutbound.newBuilder().setUnsubscribe(this.subscriptionBuilder((QueryDefinition)d, 1)).build());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.outboundStreamObserver = null;
        }

        private void resubscribe() {
            if (this.subscribedQueries.isEmpty() || this.subscribing) {
                return;
            }
            try {
                StreamObserver<QueryProviderOutbound> subscriberStreamObserver = this.getSubscriberObserver();
                this.subscribedQueries.forEach((queryDefinition, handlers) -> subscriberStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setSubscribe(this.subscriptionBuilder((QueryDefinition)queryDefinition, handlers.size())).build()));
            }
            catch (Exception ex) {
                AxonServerQueryBus.this.logger.warn("Error while resubscribing - {}", (Object)ex.getMessage());
            }
        }

        public void disconnect() {
            if (this.outboundStreamObserver != null) {
                this.outboundStreamObserver.onCompleted();
            }
        }

        private QuerySubscription.Builder subscriptionBuilder(QueryDefinition queryDefinition, int nrHandlers) {
            return QuerySubscription.newBuilder().setClientName(AxonServerQueryBus.this.configuration.getClientName()).setMessageId(UUID.randomUUID().toString()).setComponentName(queryDefinition.componentName).setQuery(queryDefinition.queryName).setNrOfHandlers(nrHandlers).setResultName(queryDefinition.responseName);
        }

        class QueryDefinition {
            private final String queryName;
            private final String responseName;
            private final String componentName;

            QueryDefinition(String queryName, String responseName, String componentName) {
                this.queryName = queryName;
                this.responseName = responseName;
                this.componentName = componentName;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                QueryDefinition that = (QueryDefinition)o;
                return Objects.equals(this.queryName, that.queryName) && Objects.equals(this.responseName, that.responseName) && Objects.equals(this.componentName, that.componentName);
            }

            public int hashCode() {
                return Objects.hash(this.queryName, this.responseName, this.componentName);
            }
        }
    }
}

