/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.util;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.axonframework.axonserver.connector.event.util.EventStoreClientException;

public class EventCipher {
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String MAGIC_NUMBER_STRING = "AxIQ";
    private static final int NONCE_LENGTH = 6;
    private Function<Event, Integer> keySelector;
    private SecretKeySpec[] secretKeys;
    private IvParameterSpec ivParameterSpec;
    private byte[] magicNumber;
    private ThreadLocal<Cipher>[] encryptingCiphers;
    private ThreadLocal<Cipher>[] decryptingCiphers;
    private ThreadLocal<SecureRandom> nonceGenerator;

    public EventCipher() {
        this(event -> -1, Collections.emptyList());
    }

    public EventCipher(byte[] secretKey) {
        this(event -> 0, Collections.singletonList(secretKey));
    }

    public EventCipher(Function<Event, Integer> keySelector, List<byte[]> secretKeys) {
        int i;
        this.keySelector = keySelector;
        this.secretKeys = new SecretKeySpec[secretKeys.size()];
        for (i = 0; i < this.secretKeys.length; ++i) {
            byte[] key = secretKeys.get(i);
            if (key.length != 16 && key.length != 24) {
                throw new EventStoreClientException("AXONIQ-8001", String.format("secret key length should be 128, 196 or 258 bits but is %d bytes for key %d", key.length, i));
            }
            this.secretKeys[i] = new SecretKeySpec(key, "AES");
        }
        this.ivParameterSpec = new IvParameterSpec(new byte[16]);
        this.magicNumber = MAGIC_NUMBER_STRING.getBytes(StandardCharsets.US_ASCII);
        this.encryptingCiphers = new ThreadLocal[this.secretKeys.length];
        for (i = 0; i < this.secretKeys.length; ++i) {
            int keyIndex = i;
            this.encryptingCiphers[i] = ThreadLocal.withInitial(() -> this.initCipher(1, keyIndex));
            this.encryptingCiphers[i].get();
        }
        this.decryptingCiphers = new ThreadLocal[this.secretKeys.length];
        for (i = 0; i < this.secretKeys.length; ++i) {
            int keyIndex = i;
            this.decryptingCiphers[i] = ThreadLocal.withInitial(() -> this.initCipher(2, keyIndex));
            this.decryptingCiphers[i].get();
        }
        this.nonceGenerator = ThreadLocal.withInitial(SecureRandom::new);
    }

    private Cipher initCipher(int mode, int keyIndex) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(mode, (Key)this.secretKeys[keyIndex], this.ivParameterSpec);
            return cipher;
        }
        catch (Exception ex) {
            throw new EventStoreClientException("AXONIQ-8000", "Unexpected exception initializing crypto algorithm", ex);
        }
    }

    public EventWithToken decrypt(EventWithToken cryptoEventWithToken) {
        return EventWithToken.newBuilder(cryptoEventWithToken).setEvent(this.decrypt(cryptoEventWithToken.getEvent())).build();
    }

    public Event encrypt(Event clearEvent) {
        int keyIndex = this.keySelector.apply(clearEvent);
        if (keyIndex < 0) {
            return clearEvent;
        }
        return Event.newBuilder(clearEvent).setPayload(SerializedObject.newBuilder(clearEvent.getPayload()).setData(ByteString.copyFrom((byte[])this.encryptBytes(keyIndex, clearEvent.getPayload().getData().toByteArray()))).build()).build();
    }

    public Event decrypt(Event cryptoEvent) {
        int keyIndex = this.keySelector.apply(cryptoEvent);
        if (keyIndex < 0) {
            return cryptoEvent;
        }
        return Event.newBuilder(cryptoEvent).setPayload(SerializedObject.newBuilder(cryptoEvent.getPayload()).setData(ByteString.copyFrom((byte[])this.decryptBytes(keyIndex, cryptoEvent.getPayload().getData().toByteArray()))).build()).build();
    }

    protected byte[] encryptBytes(int keyIndex, byte[] clearBytes) {
        Cipher cipher = this.encryptingCiphers[keyIndex].get();
        byte[] messageBytes = new byte[6 + this.magicNumber.length + clearBytes.length];
        byte[] nonce = new byte[6];
        this.nonceGenerator.get().nextBytes(nonce);
        System.arraycopy(nonce, 0, messageBytes, 0, 6);
        System.arraycopy(this.magicNumber, 0, messageBytes, 6, this.magicNumber.length);
        System.arraycopy(clearBytes, 0, messageBytes, 6 + this.magicNumber.length, clearBytes.length);
        try {
            return cipher.doFinal(messageBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            throw new EventStoreClientException("AXONIQ-8000", "Unexpected error encrypting cleartext", ex);
        }
    }

    protected byte[] decryptBytes(int keyIndex, byte[] cryptoBytes) {
        byte[] decryptedBytes;
        Cipher cipher = this.decryptingCiphers[keyIndex].get();
        try {
            decryptedBytes = cipher.doFinal(cryptoBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            throw new EventStoreClientException("AXONIQ-8002", "Crypto error decrypting payload", ex);
        }
        byte[] magicNumber = Arrays.copyOfRange(decryptedBytes, 6, 6 + this.magicNumber.length);
        if (!Arrays.equals(this.magicNumber, magicNumber)) {
            throw new EventStoreClientException("AXONIQ-8002", "Missing magic number after decryption");
        }
        return Arrays.copyOfRange(decryptedBytes, 6 + magicNumber.length, decryptedBytes.length);
    }
}

