/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import org.axonframework.axonserver.connector.event.util.EventStoreClientException;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.common.AxonException;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.modelling.command.AggregateRolledBackException;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.queryhandling.QueryExecutionException;

public enum ErrorCode {
    AUTHENTICATION_TOKEN_MISSING("AXONIQ-1000", EventStoreException.class),
    AUTHENTICATION_INVALID_TOKEN("AXONIQ-1001", EventStoreException.class),
    NODE_IS_REPLICA("AXONIQ-1100", EventStoreException.class),
    INVALID_SEQUENCE("AXONIQ-2000", ConcurrencyException.class),
    PAYLOAD_TOO_LARGE("AXONIQ-2001", EventStoreException.class),
    NO_MASTER_AVAILABLE("AXONIQ-2100", EventStoreException.class),
    CONNECTION_TO_AXONDB_FAILED("AXONIQ-6000", EventStoreException.class),
    COMMAND_EXECUTION_ERROR("AXONIQ-7000", CommandExecutionException.class),
    QUERY_EXECUTION_ERROR("AXONIQ-8000", QueryExecutionException.class),
    DATAFILE_READ_ERROR("AXONIQ-9000", EventStoreException.class),
    INDEX_READ_ERROR("AXONIQ-9001", EventStoreException.class),
    DATAFILE_WRITE_ERROR("AXONIQ-9100", EventStoreException.class),
    INDEX_WRITE_ERROR("AXONIQ-9101", EventStoreException.class),
    DIRECTORY_CREATION_FAILED("AXONIQ-9102", EventStoreException.class),
    VALIDATION_FAILED("AXONIQ-9200", EventStoreException.class),
    TRANSACTION_ROLLED_BACK("AXONIQ-9900", AggregateRolledBackException.class),
    OTHER("AXONIQ-0001", EventStoreException.class);

    private final String code;
    private final Class exceptionClass;

    private ErrorCode(String code, Class<? extends AxonException> exceptionClass) {
        this.code = code;
        this.exceptionClass = exceptionClass;
    }

    public static Class<? extends AxonException> lookupExceptionClass(String code) {
        return Arrays.stream(ErrorCode.values()).filter(mapping -> mapping.code.equals(code)).map(mapping -> mapping.exceptionClass).findFirst().orElse(ErrorCode.OTHER.exceptionClass);
    }

    public static AxonException convert(Throwable t) {
        if (t instanceof EventStoreClientException) {
            Class<? extends AxonException> clazz = ErrorCode.lookupExceptionClass(((EventStoreClientException)t).getCode());
            try {
                return clazz.getDeclaredConstructor(String.class, Throwable.class).newInstance(t.getMessage(), t.getCause());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (t instanceof TimeoutException) {
            return new ExecutionException("Timeout while executing request", t);
        }
        return new EventStoreException(t.getMessage(), t);
    }

    public static ErrorCode resolve(Throwable throwable) {
        return OTHER;
    }

    public String errorCode() {
        return this.code;
    }
}

