/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import io.axoniq.axonserver.grpc.event.Event;
import java.time.Instant;
import java.util.Map;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SimpleSerializedObject;

public class GrpcBackedDomainEventData
implements DomainEventData<byte[]> {
    private final Event event;

    public GrpcBackedDomainEventData(Event event) {
        this.event = event;
    }

    public String getType() {
        String aggregateType = this.event.getAggregateType();
        return "".equals(aggregateType) ? null : aggregateType;
    }

    public String getAggregateIdentifier() {
        String aggregateIdentifier = this.event.getAggregateIdentifier();
        return "".equals(aggregateIdentifier) ? null : aggregateIdentifier;
    }

    public long getSequenceNumber() {
        return this.event.getAggregateSequenceNumber();
    }

    public String getEventIdentifier() {
        return this.event.getMessageIdentifier();
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.event.getTimestamp());
    }

    public SerializedObject getMetaData() {
        return new SerializedMetaData(this.event.getMetaDataMap(), Map.class);
    }

    public SerializedObject<byte[]> getPayload() {
        String revision = this.event.getPayload().getRevision();
        return new SimpleSerializedObject((Object)this.event.getPayload().getData().toByteArray(), byte[].class, this.event.getPayload().getType(), "".equals(revision) ? null : revision);
    }

    public boolean isSnapshot() {
        return this.event.getSnapshot();
    }
}

