/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import java.util.UUID;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.command.GrpcBackedCommandMessage;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.Message;
import org.axonframework.serialization.Serializer;

public class CommandSerializer {
    private final AxonServerConfiguration configuration;
    private final Serializer messageSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcObjectSerializer<Object> objectSerializer;

    public CommandSerializer(Serializer serializer, AxonServerConfiguration configuration) {
        this.configuration = configuration;
        this.messageSerializer = serializer;
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetaDataConverter(this.messageSerializer));
        this.payloadSerializer = new GrpcPayloadSerializer(this.messageSerializer);
        this.objectSerializer = new GrpcObjectSerializer(this.messageSerializer);
    }

    public Command serialize(CommandMessage<?> commandMessage, String routingKey, int priority) {
        return Command.newBuilder().setName(commandMessage.getCommandName()).setMessageIdentifier(commandMessage.getIdentifier()).setTimestamp(System.currentTimeMillis()).setPayload(this.payloadSerializer.apply((Message)commandMessage)).putAllMetaData(this.metadataSerializer.apply(commandMessage.getMetaData())).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.ROUTING_KEY).setValue(MetaDataValue.newBuilder().setTextValue(routingKey))).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.PRIORITY).setValue(MetaDataValue.newBuilder().setNumberValue(priority))).setClientId(this.configuration.getComponentName()).setComponentName(this.configuration.getComponentName()).build();
    }

    public CommandMessage<?> deserialize(Command request) {
        return new GrpcBackedCommandMessage(request, this.messageSerializer);
    }

    public Object deserialize(CommandResponse response) {
        return this.messageSerializer.deserialize((org.axonframework.serialization.SerializedObject)new GrpcSerializedObject(response.getPayload()));
    }

    CommandProviderOutbound serialize(Object payload, String requestIdentifier) {
        CommandResponse.Builder responseBuilder = CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(requestIdentifier);
        if (payload != null) {
            responseBuilder.setPayload((SerializedObject)this.objectSerializer.apply(payload));
        }
        return CommandProviderOutbound.newBuilder().setCommandResponse(responseBuilder).build();
    }
}

