/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.conversion.ConversionException;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.commandhandling.GenericCommandResultMessage;
import org.axonframework.messaging.commandhandling.annotation.CommandHandlingMember;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.core.annotation.MessageHandlingMember;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.conversion.EventConverter;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.annotation.AnnotationBasedEntityEvolvingComponent;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.EntityMetamodelBuilder;
import org.axonframework.modelling.entity.PolymorphicEntityMetamodel;
import org.axonframework.modelling.entity.PolymorphicEntityMetamodelBuilder;
import org.axonframework.modelling.entity.annotation.EntityChildModelDefinition;
import org.axonframework.modelling.entity.child.EntityChildMetamodel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedEntityMetamodel<E>
implements EntityMetamodel<E>,
DescribableComponent {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedEntityMetamodel.class);
    private final Class<E> entityType;
    private final EntityMetamodel<E> delegateMetamodel;
    private final ParameterResolverFactory parameterResolverFactory;
    private final MessageTypeResolver messageTypeResolver;
    private final MessageConverter messageConverter;
    private final EventConverter eventConverter;
    private final Map<QualifiedName, Class<?>> payloadTypes = new HashMap();
    private final List<AnnotatedEntityMetamodel<?>> concreteMetamodels = new LinkedList();
    private final List<AnnotatedEntityMetamodel<?>> childMetamodels = new LinkedList();
    private final List<QualifiedName> commandsToSkip;

    public static <E> AnnotatedEntityMetamodel<E> forConcreteType(@Nonnull Class<E> entityType, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull MessageConverter messageConverter, @Nonnull EventConverter eventConverter) {
        return new AnnotatedEntityMetamodel<E>(entityType, Set.of(), parameterResolverFactory, messageTypeResolver, messageConverter, eventConverter, List.of());
    }

    public static <E> AnnotatedEntityMetamodel<E> forPolymorphicType(@Nonnull Class<E> entityType, @Nonnull Set<Class<? extends E>> concreteTypes, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull MessageConverter messageConverter, @Nonnull EventConverter eventConverter) {
        Objects.requireNonNull(concreteTypes, "The concreteTypes may not be null.");
        Assert.isTrue((!concreteTypes.isEmpty() ? 1 : 0) != 0, () -> "The concreteTypes set must not be empty for a polymorphic entity type.");
        return new AnnotatedEntityMetamodel<E>(entityType, concreteTypes, parameterResolverFactory, messageTypeResolver, messageConverter, eventConverter, List.of());
    }

    private AnnotatedEntityMetamodel(@Nonnull Class<E> entityType, @Nonnull Set<Class<? extends E>> concreteTypes, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull MessageConverter messageConverter, @Nonnull EventConverter eventConverter, @Nonnull List<QualifiedName> commandsToSkip) {
        this.commandsToSkip = Objects.requireNonNull(commandsToSkip, "The commandsToSkip may not be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entityType may not be null.");
        this.parameterResolverFactory = Objects.requireNonNull(parameterResolverFactory, "The parameterResolverFactory may not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The messageTypeResolver may not be null.");
        this.messageConverter = Objects.requireNonNull(messageConverter, "The MessageConverter may not be null.");
        this.eventConverter = Objects.requireNonNull(eventConverter, "The EventConverter may not be null.");
        Objects.requireNonNull(concreteTypes, "The concreteTypes may not be null.");
        this.delegateMetamodel = !concreteTypes.isEmpty() ? this.initializePolymorphicMetamodel(entityType, concreteTypes) : this.initializeConcreteModel(entityType);
    }

    private EntityMetamodel<E> initializeConcreteModel(Class<E> entityType) {
        EntityMetamodelBuilder<E> builder = EntityMetamodel.forEntityType(entityType);
        AnnotatedHandlerInspector inspected = AnnotatedHandlerInspector.inspectType(entityType, (ParameterResolverFactory)this.parameterResolverFactory);
        builder.entityEvolver(new AnnotationBasedEntityEvolvingComponent<E>(entityType, inspected, this.eventConverter, this.messageTypeResolver));
        this.initializeDetectedHandlers(builder, inspected);
        this.initializeChildren(builder);
        return builder.build();
    }

    private EntityMetamodel<E> initializePolymorphicMetamodel(Class<E> entityType, Set<Class<? extends E>> concreteTypes) {
        AnnotatedHandlerInspector inspected = AnnotatedHandlerInspector.inspectType(entityType, (ParameterResolverFactory)this.parameterResolverFactory);
        PolymorphicEntityMetamodelBuilder<E> builder = PolymorphicEntityMetamodel.forSuperType(entityType);
        builder.entityEvolver((EntityEvolver)new AnnotationBasedEntityEvolvingComponent<E>(entityType, inspected, this.eventConverter, this.messageTypeResolver));
        this.initializeChildren(builder);
        LinkedList<QualifiedName> registeredCommands = this.initializeDetectedHandlers(builder, inspected);
        concreteTypes.forEach(concreteType -> {
            AnnotatedEntityMetamodel<? extends E> createdConcreteEntityModel = new AnnotatedEntityMetamodel<E>(concreteType, Set.of(), this.parameterResolverFactory, this.messageTypeResolver, this.messageConverter, this.eventConverter, (List<QualifiedName>)registeredCommands);
            this.concreteMetamodels.add(createdConcreteEntityModel);
            builder.addConcreteType(createdConcreteEntityModel);
        });
        return builder.build();
    }

    private LinkedList<QualifiedName> initializeDetectedHandlers(EntityMetamodelBuilder<E> builder, AnnotatedHandlerInspector<E> inspected) {
        LinkedList<QualifiedName> registeredCommands = new LinkedList<QualifiedName>();
        inspected.getHandlers(this.entityType).stream().filter(h -> h.canHandleMessageType(CommandMessage.class) || h.canHandleMessageType(EventMessage.class)).filter(h -> h.unwrap(Method.class).map(m -> !Modifier.isAbstract(m.getModifiers())).orElse(false)).forEach(handler -> {
            QualifiedName qualifiedName = this.messageTypeResolver.resolveOrThrow(handler.payloadType()).qualifiedName();
            if (this.commandsToSkip.contains(qualifiedName)) {
                logger.debug("Skipping registration of command handler for [{}] on [{}] (already registered by parent)", (Object)qualifiedName, this.entityType);
                return;
            }
            this.addPayloadTypeFromHandler(qualifiedName, (MessageHandlingMember<?>)handler);
            this.addCommandHandlerToModel(builder, (MessageHandlingMember<? super E>)handler, qualifiedName, registeredCommands);
        });
        return registeredCommands;
    }

    private void addCommandHandlerToModel(EntityMetamodelBuilder<E> builder, MessageHandlingMember<? super E> handler, QualifiedName qualifiedName, LinkedList<QualifiedName> registeredCommands) {
        if (!(handler instanceof CommandHandlingMember)) {
            return;
        }
        CommandHandlingMember commandMember = (CommandHandlingMember)handler;
        registeredCommands.add(qualifiedName);
        if (commandMember.isFactoryHandler()) {
            logger.debug("Registered creational command handler for [{}] on [{}]", (Object)qualifiedName, this.entityType);
            builder.creationalCommandHandler(qualifiedName, (command, context) -> handler.handle((Message)command, context, null).mapMessage(GenericCommandResultMessage::new).first());
        } else {
            logger.debug("Registered instance command handler for [{}] on [{}]", (Object)qualifiedName, this.entityType);
            builder.instanceCommandHandler(qualifiedName, (command, entity, context) -> handler.handle((Message)command, context, entity).mapMessage(GenericCommandResultMessage::new).first());
        }
    }

    private void addPayloadTypeFromHandler(QualifiedName qualifiedName, MessageHandlingMember<?> handler) {
        if (this.payloadTypes.containsKey(qualifiedName) && !this.payloadTypes.get(qualifiedName).equals(handler.payloadType())) {
            throw new AxonConfigurationException("The scanned message handler methods expect different payload types for the same message type. Message of qualified name [" + String.valueOf(qualifiedName) + "] declares both [" + String.valueOf(this.payloadTypes.get(qualifiedName)) + "] and [" + String.valueOf(handler.payloadType()) + "] as wanted representations");
        }
        logger.debug("Discovered payload type [{}] for message type [{}] on entity [{}]", new Object[]{handler.payloadType().getName(), qualifiedName, this.entityType});
        this.payloadTypes.put(qualifiedName, handler.payloadType());
    }

    @Nullable
    public Class<?> getExpectedRepresentation(@Nonnull QualifiedName qualifiedName) {
        Class<?> payloadType;
        if (this.payloadTypes.containsKey(qualifiedName)) {
            return this.payloadTypes.get(qualifiedName);
        }
        for (AnnotatedEntityMetamodel<?> concreteMetamodel : this.concreteMetamodels) {
            payloadType = concreteMetamodel.getExpectedRepresentation(qualifiedName);
            if (payloadType == null) continue;
            return payloadType;
        }
        for (AnnotatedEntityMetamodel<?> child : this.childMetamodels) {
            payloadType = child.getExpectedRepresentation(qualifiedName);
            if (payloadType == null) continue;
            return payloadType;
        }
        return null;
    }

    private void initializeChildren(EntityMetamodelBuilder<E> builder) {
        ServiceLoader<EntityChildModelDefinition> childEntityDefinitions = ServiceLoader.load(EntityChildModelDefinition.class, this.entityType.getClassLoader());
        List<Method> methods = StreamSupport.stream(ReflectionUtils.methodsOf(this.entityType).spliterator(), false).toList();
        List<Field> fields = StreamSupport.stream(ReflectionUtils.fieldsOf(this.entityType).spliterator(), false).toList();
        methods.forEach(method -> this.createOptionalChildForMember(builder, (Member)method, childEntityDefinitions));
        if (this.entityType.isRecord()) {
            fields = AnnotatedEntityMetamodel.deduplicateRecordFields(fields, methods);
        }
        fields.forEach(field -> this.createOptionalChildForMember(builder, (Member)field, childEntityDefinitions));
    }

    private static List<Field> deduplicateRecordFields(List<Field> fields, List<Method> methods) {
        return fields.stream().filter(field -> methods.stream().noneMatch(method -> method.getName().equals(field.getName()) && method.getParameterCount() == 0 && method.getReturnType().equals(field.getType()))).toList();
    }

    private void createOptionalChildForMember(EntityMetamodelBuilder<E> builder, Member field, ServiceLoader<EntityChildModelDefinition> childEntityDefinitions) {
        List<EntityChildMetamodel> createdChildModels = childEntityDefinitions.stream().map(ServiceLoader.Provider::get).map(d -> d.createChildDefinition(this.entityType, this::createChildEntityModel, field)).filter(Optional::isPresent).map(Optional::get).toList();
        if (createdChildModels.size() > 1) {
            throw new IllegalStateException("Multiple child entity definitions found for member [" + String.valueOf(field) + "] of entity type [" + String.valueOf(this.entityType) + "]. Please ensure only one definition is present for this member. Found definitions: " + String.valueOf(createdChildModels));
        }
        if (createdChildModels.size() == 1) {
            EntityChildMetamodel child = createdChildModels.getFirst();
            EntityMetamodel entityMetamodel = child.entityMetamodel();
            if (entityMetamodel instanceof AnnotatedEntityMetamodel) {
                AnnotatedEntityMetamodel annotatedChild = (AnnotatedEntityMetamodel)entityMetamodel;
                this.childMetamodels.add(annotatedChild);
            }
            logger.debug("Discovered child entity [{}] for member [{}] on entity [{}]", new Object[]{child.entityMetamodel().entityType().getName(), field.getName(), this.entityType});
            builder.addChild(child);
        }
    }

    private <C> AnnotatedEntityMetamodel<C> createChildEntityModel(Class<C> clazz) {
        logger.debug("Creating child entity metamodel for class: {}", clazz);
        return new AnnotatedEntityMetamodel<E>(clazz, Set.of(), this.parameterResolverFactory, this.messageTypeResolver, this.messageConverter, this.eventConverter, List.of());
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedCommands() {
        return Collections.unmodifiableSet(this.delegateMetamodel.supportedCommands());
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedCreationalCommands() {
        return Collections.unmodifiableSet(this.delegateMetamodel.supportedCreationalCommands());
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedInstanceCommands() {
        return Collections.unmodifiableSet(this.delegateMetamodel.supportedInstanceCommands());
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handleCreate(@Nonnull CommandMessage message, @Nonnull ProcessingContext context) {
        Class<?> expectedRepresentation;
        MessageType type = message.type();
        if (logger.isDebugEnabled()) {
            logger.debug("Handling creation command: {} for type: {}", (Object)type, this.entityType());
        }
        if ((expectedRepresentation = this.getExpectedRepresentation(type.qualifiedName())) == null) {
            throw new ConversionException(String.format("Cannot convert command [%s] for handling since entity [%s] has no handler for this command type.", type, this.entityType()));
        }
        CommandMessage convertedMessage = message.withConvertedPayload(expectedRepresentation, (Converter)this.messageConverter);
        return this.delegateMetamodel.handleCreate(convertedMessage, context);
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handleInstance(@Nonnull CommandMessage message, @Nonnull E entity, @Nonnull ProcessingContext context) {
        Class<?> expectedRepresentation;
        MessageType type = message.type();
        if (logger.isDebugEnabled()) {
            logger.debug("Handling instance command: {} for entity: {} of type: {}", new Object[]{type, entity, this.entityType()});
        }
        if ((expectedRepresentation = this.getExpectedRepresentation(type.qualifiedName())) == null) {
            throw new ConversionException(String.format("Cannot convert command [%s] for handling since entity [%s] has no handler for this command type.", type, this.entityType()));
        }
        CommandMessage convertedMessage = message.withConvertedPayload(expectedRepresentation, (Converter)this.messageConverter);
        return this.delegateMetamodel.handleInstance(convertedMessage, entity, context);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        logger.debug("Describing entity metamodel to descriptor for entity type: {}", this.entityType());
        descriptor.describeWrapperOf(this.delegateMetamodel);
        descriptor.describeProperty("entityType", this.entityType());
    }

    @Override
    public E evolve(@Nonnull E entity, @Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        logger.debug("Evolving entity: {} with event: {} for entity type: {}", new Object[]{entity, event.type(), this.entityType()});
        return this.delegateMetamodel.evolve(entity, event, context);
    }

    @Override
    @Nonnull
    public Class<E> entityType() {
        return this.entityType;
    }

    MessageConverter messageConverter() {
        return this.messageConverter;
    }
}

