/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.common.configuration.ApplicationConfigurer;
import org.axonframework.common.configuration.AxonConfiguration;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.common.configuration.Module;
import org.axonframework.common.configuration.ModuleBuilder;
import org.axonframework.messaging.commandhandling.configuration.CommandHandlingModule;
import org.axonframework.messaging.core.configuration.MessagingConfigurer;
import org.axonframework.messaging.queryhandling.configuration.QueryHandlingModule;
import org.axonframework.modelling.configuration.EntityModule;
import org.axonframework.modelling.configuration.ModellingConfigurationDefaults;

public class ModellingConfigurer
implements ApplicationConfigurer {
    private final MessagingConfigurer delegate;

    public static ModellingConfigurer create() {
        return ModellingConfigurer.enhance(MessagingConfigurer.create());
    }

    public static ModellingConfigurer enhance(@Nonnull MessagingConfigurer messagingConfigurer) {
        return new ModellingConfigurer(messagingConfigurer).componentRegistry(cr -> cr.registerEnhancer((ConfigurationEnhancer)new ModellingConfigurationDefaults()));
    }

    public ModellingConfigurer(@Nonnull MessagingConfigurer delegate) {
        Objects.requireNonNull(delegate, "The delegate MessagingConfigurer may not be null");
        this.delegate = delegate;
    }

    @Nonnull
    public ModellingConfigurer registerCommandHandlingModule(@Nonnull ModuleBuilder<CommandHandlingModule> moduleBuilder) {
        return this.messaging(messagingConfigurer -> messagingConfigurer.registerCommandHandlingModule(moduleBuilder));
    }

    @Nonnull
    public ModellingConfigurer registerQueryHandlingModule(@Nonnull ModuleBuilder<QueryHandlingModule> moduleBuilder) {
        return this.messaging(messagingConfigurer -> messagingConfigurer.registerQueryHandlingModule(moduleBuilder));
    }

    @Nonnull
    public <I, E> ModellingConfigurer registerEntity(@Nonnull EntityModule<I, E> entityModule) {
        Objects.requireNonNull(entityModule, "EntityModule may not be null");
        this.delegate.componentRegistry(cr -> cr.registerModule((Module)entityModule));
        return this;
    }

    public ModellingConfigurer messaging(@Nonnull Consumer<MessagingConfigurer> configurerTask) {
        configurerTask.accept(this.delegate);
        return this;
    }

    public ModellingConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        this.delegate.componentRegistry(componentRegistrar);
        return this;
    }

    public ModellingConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        this.delegate.lifecycleRegistry(lifecycleRegistrar);
        return this;
    }

    public AxonConfiguration build() {
        return this.delegate.build();
    }
}

