/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.child;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.child.AbstractEntityChildMetamodel;
import org.axonframework.modelling.entity.child.ChildEntityFieldDefinition;
import org.axonframework.modelling.entity.child.CommandTargetResolver;
import org.axonframework.modelling.entity.child.EventTargetMatcher;

public class SingleEntityChildMetamodel<C, P>
extends AbstractEntityChildMetamodel<C, P> {
    private final ChildEntityFieldDefinition<P, C> childEntityFieldDefinition;

    private SingleEntityChildMetamodel(@Nonnull EntityMetamodel<C> metamodel, @Nonnull ChildEntityFieldDefinition<P, C> childEntityFieldDefinition, @Nonnull CommandTargetResolver<C> commandTargetMatcher, @Nonnull EventTargetMatcher<C> eventTargetMatcher) {
        super(metamodel, commandTargetMatcher, eventTargetMatcher);
        this.childEntityFieldDefinition = Objects.requireNonNull(childEntityFieldDefinition, "The childEntityFieldDefinition may not be null.");
    }

    @Override
    protected List<C> getChildEntities(P entity) {
        C childEntity = this.childEntityFieldDefinition.getChildValue(entity);
        if (childEntity != null) {
            return List.of(childEntity);
        }
        return List.of();
    }

    @Override
    protected P applyEvolvedChildEntities(P entity, List<C> evolvedChildEntities) {
        if (evolvedChildEntities.isEmpty()) {
            return this.childEntityFieldDefinition.evolveParentBasedOnChildInput(entity, null);
        }
        if (evolvedChildEntities.size() > 1) {
            throw new IllegalStateException("The SingleEntityChildModel field should only return a single child entity.");
        }
        return this.childEntityFieldDefinition.evolveParentBasedOnChildInput(entity, evolvedChildEntities.getFirst());
    }

    @Override
    @Nonnull
    public EntityMetamodel<C> entityMetamodel() {
        return this.metamodel;
    }

    public String toString() {
        return "SingleEntityChildMetaModel{entityType=" + this.entityType().getName() + "}";
    }

    public static <C, P> Builder<C, P> forEntityModel(@Nonnull Class<P> parentClass, @Nonnull EntityMetamodel<C> metamodel) {
        return new Builder<C, P>(parentClass, metamodel);
    }

    public static class Builder<C, P>
    extends AbstractEntityChildMetamodel.Builder<C, P, Builder<C, P>> {
        private ChildEntityFieldDefinition<P, C> childEntityFieldDefinition;

        private Builder(@Nonnull Class<P> parentClass, @Nonnull EntityMetamodel<C> childEntityMetamodel) {
            super(parentClass, childEntityMetamodel);
            this.commandTargetResolver = CommandTargetResolver.MATCH_ANY();
            this.eventTargetMatcher = EventTargetMatcher.MATCH_ANY();
        }

        public Builder<C, P> childEntityFieldDefinition(@Nonnull ChildEntityFieldDefinition<P, C> fieldDefinition) {
            this.childEntityFieldDefinition = Objects.requireNonNull(fieldDefinition, "The fieldDefinition may not be null.");
            return this;
        }

        public SingleEntityChildMetamodel<C, P> build() {
            this.validate();
            return new SingleEntityChildMetamodel<C, P>(this.metamodel, this.childEntityFieldDefinition, this.commandTargetResolver, this.eventTargetMatcher);
        }
    }
}

