/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.child;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.axonframework.modelling.entity.child.ChildEntityFieldDefinition;

public class GetterSetterChildEntityFieldDefinition<P, F>
implements ChildEntityFieldDefinition<P, F> {
    private final Function<P, F> getter;
    private final BiConsumer<P, F> setter;

    public GetterSetterChildEntityFieldDefinition(@Nonnull Function<P, F> getter, @Nonnull BiConsumer<P, F> setter) {
        this.getter = Objects.requireNonNull(getter, "The getter may not be null.");
        this.setter = Objects.requireNonNull(setter, "The setter may not be null.");
    }

    @Override
    @Nonnull
    public P evolveParentBasedOnChildInput(@Nonnull P parentEntity, @Nonnull F childInput) {
        this.setter.accept(parentEntity, childInput);
        return parentEntity;
    }

    @Override
    public F getChildValue(@Nonnull P parentEntity) {
        return this.getter.apply(parentEntity);
    }
}

