/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.child;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.axonframework.modelling.entity.child.ChildEntityFieldDefinition;

public class GetterEvolverChildEntityFieldDefinition<P, F>
implements ChildEntityFieldDefinition<P, F> {
    private final Function<P, F> getter;
    private final BiFunction<P, F, P> evolver;

    public GetterEvolverChildEntityFieldDefinition(@Nonnull Function<P, F> getter, @Nonnull BiFunction<P, F, P> evolver) {
        this.getter = Objects.requireNonNull(getter, "The getter may not be null.");
        this.evolver = Objects.requireNonNull(evolver, "The evolver may not be null.");
    }

    @Override
    @Nonnull
    public P evolveParentBasedOnChildInput(@Nonnull P parentEntity, @Nonnull F childInput) {
        return this.evolver.apply(parentEntity, childInput);
    }

    @Override
    public F getChildValue(@Nonnull P parentEntity) {
        return this.getter.apply(parentEntity);
    }
}

