/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.commandhandling.annotations.RoutingKey;
import org.axonframework.common.annotations.AnnotationUtils;
import org.axonframework.common.annotations.Internal;
import org.axonframework.modelling.entity.annotations.EntityMember;

@Internal
public class RoutingKeyUtils {
    private RoutingKeyUtils() {
    }

    public static Optional<String> getMessageRoutingKey(@Nonnull AnnotatedElement member) {
        Objects.requireNonNull(member, "The member must not be null.");
        Optional attributes = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)member, EntityMember.class);
        if (attributes.isEmpty()) {
            return Optional.empty();
        }
        String routingKeyProperty = (String)((Map)attributes.get()).get("routingKey");
        if (!routingKeyProperty.isEmpty()) {
            return Optional.of(routingKeyProperty);
        }
        return Optional.empty();
    }

    public static Optional<String> getEntityRoutingKey(@Nonnull Class<?> childEntityClass) {
        Objects.requireNonNull(childEntityClass, "The childEntityClass must not be null.");
        return Arrays.stream(childEntityClass.getDeclaredFields()).filter(field -> AnnotationUtils.isAnnotationPresent((AnnotatedElement)field, RoutingKey.class)).findFirst().map(Field::getName);
    }
}

