/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling;

import java.util.List;

public class EntityIdResolutionException
extends Exception {
    public EntityIdResolutionException(Class<?> cls, List<Object> identifiers) {
        super(EntityIdResolutionException.createMessage(cls, identifiers));
    }

    private static String createMessage(Class<?> cls, List<Object> identifiers) {
        if (identifiers == null || identifiers.size() == 1) {
            throw new IllegalArgumentException("identifiers cannot be null or contain exactly one element: " + String.valueOf(identifiers));
        }
        return "Unable to resolve id for payload of type [%s]: %s".formatted(cls, identifiers.isEmpty() ? "found no identifiers" : "found multiple identifiers: %s".formatted(identifiers));
    }
}

