/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.repository;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;
import org.axonframework.modelling.repository.SimpleRepositoryEntityLoader;
import org.axonframework.modelling.repository.SimpleRepositoryEntityPersister;

public class SimpleRepository<ID, E>
implements Repository.LifecycleManagement<ID, E> {
    private final Context.ResourceKey<Map<ID, CompletableFuture<ManagedEntity<ID, E>>>> managedEntitiesKey = Context.ResourceKey.withLabel((String)"SimpleRepository.ManagedEntities");
    private final Class<ID> idType;
    private final Class<E> entityType;
    private final SimpleRepositoryEntityLoader<ID, E> loader;
    private final SimpleRepositoryEntityPersister<ID, E> persister;

    public SimpleRepository(@Nonnull Class<ID> idType, @Nonnull Class<E> entityType, @Nonnull SimpleRepositoryEntityLoader<ID, E> loader, @Nonnull SimpleRepositoryEntityPersister<ID, E> persister) {
        this.idType = Objects.requireNonNull(idType, "The entityIdClass may not be null");
        this.entityType = Objects.requireNonNull(entityType, "The entityClass may not be null");
        this.loader = Objects.requireNonNull(loader, "The loader may not be null");
        this.persister = Objects.requireNonNull(persister, "The persister may not be null");
    }

    @Override
    public ManagedEntity<ID, E> attach(@Nonnull ManagedEntity<ID, E> entity, @Nonnull ProcessingContext context) {
        Map managedEntities = (Map)context.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return (ManagedEntity)managedEntities.computeIfAbsent(entity.identifier(), id -> {
            SimpleEntity simpleEntity = SimpleEntity.mapToSimpleEntity(entity);
            this.attachEntitySaveToContext(id, simpleEntity, context);
            return CompletableFuture.completedFuture(simpleEntity);
        }).resultNow();
    }

    @Override
    @Nonnull
    public Class<E> entityType() {
        return this.entityType;
    }

    @Override
    @Nonnull
    public Class<ID> idType() {
        return this.idType;
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, E>> load(@Nonnull ID id, @Nonnull ProcessingContext context) {
        Map managedEntities = (Map)context.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return managedEntities.computeIfAbsent(id, identifier -> this.loader.load(identifier, context).thenApply(entity -> {
            SimpleEntity<Object, Object> managedEntity = new SimpleEntity<Object, Object>(id, entity);
            this.attachEntitySaveToContext(id, managedEntity, context);
            return managedEntity;
        }));
    }

    private void attachEntitySaveToContext(ID id, ManagedEntity<ID, E> managedEntity, ProcessingContext context) {
        context.onPrepareCommit(uow -> this.persister.persist(id, managedEntity.entity(), (ProcessingContext)uow));
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, E>> loadOrCreate(@Nonnull ID identifier, @Nonnull ProcessingContext processingContext) {
        return this.load(identifier, processingContext);
    }

    @Override
    public ManagedEntity<ID, E> persist(@Nonnull ID id, @Nonnull E entity, @Nonnull ProcessingContext context) {
        Map managedEntities = (Map)context.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        if (managedEntities.containsKey(id)) {
            ManagedEntity managedEntity = (ManagedEntity)((CompletableFuture)managedEntities.get(id)).join();
            managedEntity.applyStateChange(oldState -> entity);
            return managedEntity;
        }
        SimpleEntity<ID, E> managedEntity = new SimpleEntity<ID, E>(id, entity);
        this.attachEntitySaveToContext(id, managedEntity, context);
        managedEntities.put(id, CompletableFuture.completedFuture(managedEntity));
        return managedEntity;
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("idClass", this.idType);
        descriptor.describeProperty("entityClass", this.entityType);
        descriptor.describeProperty("loader", this.loader);
        descriptor.describeProperty("persister", this.persister);
    }

    private static class SimpleEntity<I, T>
    implements ManagedEntity<I, T> {
        private final I id;
        private final AtomicReference<T> state;

        private SimpleEntity(I id, T state) {
            this.id = id;
            this.state = new AtomicReference<T>(state);
        }

        private static <ID, T> SimpleEntity<ID, T> mapToSimpleEntity(ManagedEntity<ID, T> entity) {
            SimpleEntity<ID, T> simpleEntity;
            if (entity instanceof SimpleEntity) {
                SimpleEntity simpleEntity2 = (SimpleEntity)entity;
                simpleEntity = simpleEntity2;
            } else {
                simpleEntity = new SimpleEntity<ID, T>(entity.identifier(), entity.entity());
            }
            return simpleEntity;
        }

        @Override
        public I identifier() {
            return this.id;
        }

        @Override
        public T entity() {
            return this.state.get();
        }

        @Override
        public T applyStateChange(UnaryOperator<T> change) {
            return this.state.updateAndGet(change);
        }
    }
}

