/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Optional;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.modelling.entity.annotations.AnnotatedEntityMetamodel;
import org.axonframework.modelling.entity.annotations.EventTargetMatcherDefinition;
import org.axonframework.modelling.entity.annotations.RoutingKeyEventTargetMatcher;
import org.axonframework.modelling.entity.annotations.RoutingKeyUtils;
import org.axonframework.modelling.entity.child.EventTargetMatcher;

public class RoutingKeyEventTargetMatcherDefinition
implements EventTargetMatcherDefinition {
    @Override
    @Nonnull
    public <E> EventTargetMatcher<E> createChildEntityMatcher(@Nonnull AnnotatedEntityMetamodel<E> entity, @Nonnull Member member) {
        Optional<String> messageRoutingField = RoutingKeyUtils.getMessageRoutingKey((AnnotatedElement)((Object)member));
        Optional<String> entityRoutingField = RoutingKeyUtils.getEntityRoutingKey(entity.entityType());
        if (messageRoutingField.isPresent() && entityRoutingField.isPresent()) {
            return new RoutingKeyEventTargetMatcher<E>(entity, entityRoutingField.get(), messageRoutingField.get());
        }
        if (entityRoutingField.isPresent()) {
            return new RoutingKeyEventTargetMatcher<E>(entity, entityRoutingField.get(), entityRoutingField.get());
        }
        Class memberValueType = ReflectionUtils.getMemberValueType((Member)member);
        if (Iterable.class.isAssignableFrom(memberValueType)) {
            throw new AxonConfigurationException(String.format("Member [%s] of type [%s] is a collection type, but the child does not define a @RoutingKey. Please implement a custom EventTargetMatcher for this collection type or add @RoutingKey to a field or method to identify the child entity correctly.", member, memberValueType));
        }
        return EventTargetMatcher.MATCH_ANY();
    }
}

