/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.DelayedMessageStream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;

public class EntityCommandHandlingComponent<ID, E>
implements CommandHandlingComponent,
DescribableComponent {
    private final Repository<ID, E> repository;
    private final EntityMetamodel<E> metamodel;
    private final EntityIdResolver<ID> idResolver;

    public EntityCommandHandlingComponent(@Nonnull Repository<ID, E> repository, @Nonnull EntityMetamodel<E> metamodel, @Nonnull EntityIdResolver<ID> idResolver) {
        this.repository = Objects.requireNonNull(repository, "The repository may not be null.");
        this.metamodel = Objects.requireNonNull(metamodel, "The metamodel may not be null.");
        this.idResolver = Objects.requireNonNull(idResolver, "The idResolver may not be null.");
    }

    public Set<QualifiedName> supportedCommands() {
        return this.metamodel.supportedCommands();
    }

    @Nonnull
    public MessageStream.Single<CommandResultMessage> handle(@Nonnull CommandMessage command, @Nonnull ProcessingContext context) {
        try {
            ID id = this.idResolver.resolve((Message)command, context);
            QualifiedName messageName = command.type().qualifiedName();
            CompletableFuture<ManagedEntity<ID, E>> loadFuture = this.loadFromRepository(context, id, messageName);
            return DelayedMessageStream.createSingle((CompletableFuture)loadFuture.thenApply(me -> {
                try {
                    if (me.entity() != null) {
                        return this.metamodel.handleInstance(command, me.entity(), context).first();
                    }
                    return this.metamodel.handleCreate(command, context).first();
                }
                catch (Exception e) {
                    return MessageStream.failed((Throwable)e);
                }
            }));
        }
        catch (Exception e) {
            return MessageStream.failed((Throwable)e);
        }
    }

    private CompletableFuture<ManagedEntity<ID, E>> loadFromRepository(ProcessingContext context, ID id, QualifiedName messageName) {
        boolean isCreationalHandler = this.metamodel.supportedCreationalCommands().contains(messageName);
        boolean isInstanceHandler = this.metamodel.supportedInstanceCommands().contains(messageName);
        if (isCreationalHandler) {
            return this.repository.load(id, context);
        }
        if (isInstanceHandler) {
            return this.repository.loadOrCreate(id, context);
        }
        throw new NoHandlerForCommandException("No handler for command [%s] in entity [%s] with id [%s]. Ensure that the command is either a creational or an instance command.".formatted(messageName, this.metamodel.entityType().getName(), id));
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("repository", this.repository);
        descriptor.describeProperty("metamodel", this.metamodel);
        descriptor.describeProperty("idResolver", this.idResolver);
    }
}

