/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.child;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.child.AbstractEntityChildMetamodel;
import org.axonframework.modelling.entity.child.ChildEntityFieldDefinition;
import org.axonframework.modelling.entity.child.CommandTargetResolver;
import org.axonframework.modelling.entity.child.EventTargetMatcher;

public class ListEntityChildMetamodel<C, P>
extends AbstractEntityChildMetamodel<C, P> {
    private final ChildEntityFieldDefinition<P, List<C>> childEntityFieldDefinition;

    private ListEntityChildMetamodel(@Nonnull EntityMetamodel<C> metamodel, @Nonnull ChildEntityFieldDefinition<P, List<C>> childEntityFieldDefinition, @Nonnull CommandTargetResolver<C> commandTargetResolver, @Nonnull EventTargetMatcher<C> eventTargetMatcher) {
        super(metamodel, commandTargetResolver, eventTargetMatcher);
        this.childEntityFieldDefinition = Objects.requireNonNull(childEntityFieldDefinition, "The childEntityFieldDefinition may not be null.");
    }

    @Override
    protected List<C> getChildEntities(P entity) {
        List<C> childEntities = this.childEntityFieldDefinition.getChildValue(entity);
        if (childEntities == null) {
            return List.of();
        }
        return childEntities;
    }

    @Override
    protected P applyEvolvedChildEntities(P entity, List<C> evolvedChildEntities) {
        return this.childEntityFieldDefinition.evolveParentBasedOnChildInput(entity, evolvedChildEntities);
    }

    @Override
    @Nonnull
    public EntityMetamodel<C> entityMetamodel() {
        return this.metamodel;
    }

    public String toString() {
        return "ListEntityChildModel{entityType=" + this.entityType().getName() + "}";
    }

    @Nonnull
    public static <C, P> Builder<C, P> forEntityModel(@Nonnull Class<P> parentClass, @Nonnull EntityMetamodel<C> entityMetamodel) {
        return new Builder<C, P>(parentClass, entityMetamodel);
    }

    public static class Builder<C, P>
    extends AbstractEntityChildMetamodel.Builder<C, P, Builder<C, P>> {
        private ChildEntityFieldDefinition<P, List<C>> childEntityFieldDefinition;

        private Builder(@Nonnull Class<P> parentClass, @Nonnull EntityMetamodel<C> metamodel) {
            super(parentClass, metamodel);
        }

        public Builder<C, P> childEntityFieldDefinition(@Nonnull ChildEntityFieldDefinition<P, List<C>> fieldDefinition) {
            this.childEntityFieldDefinition = Objects.requireNonNull(fieldDefinition, "The childEntityFieldDefinition may not be null.");
            return this;
        }

        public ListEntityChildMetamodel<C, P> build() {
            this.validate();
            return new ListEntityChildMetamodel<C, P>(this.metamodel, this.childEntityFieldDefinition, this.commandTargetResolver, this.eventTargetMatcher);
        }
    }
}

