/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.axonframework.common.ConstructorUtils;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.PropertyBasedEntityIdResolver;
import org.axonframework.modelling.annotation.InjectEntity;
import org.axonframework.modelling.annotation.InjectEntityParameterResolver;
import org.axonframework.modelling.repository.ManagedEntity;

public class InjectEntityParameterResolverFactory
implements ParameterResolverFactory {
    private final Configuration configuration;

    public InjectEntityParameterResolverFactory(@Nonnull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "The Configuration is required");
    }

    @Nullable
    public ParameterResolver<?> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        if (!parameter.isAnnotationPresent(InjectEntity.class)) {
            return null;
        }
        InjectEntity annotation = parameter.getAnnotation(InjectEntity.class);
        EntityIdResolver<?> entityIdResolver = InjectEntityParameterResolverFactory.getEntityIdResolver(annotation);
        Class entityClass = parameter.getType();
        boolean isManagedEntity = ManagedEntity.class.isAssignableFrom(entityClass);
        if (isManagedEntity) {
            ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
            entityClass = (Class)parameterizedType.getActualTypeArguments()[1];
        }
        return new InjectEntityParameterResolver(this.configuration, entityClass, entityIdResolver, isManagedEntity);
    }

    private static EntityIdResolver<?> getEntityIdResolver(InjectEntity annotation) {
        if (annotation.idProperty() != null && !annotation.idProperty().isEmpty()) {
            return new PropertyBasedEntityIdResolver(annotation.idProperty());
        }
        try {
            return (EntityIdResolver)ConstructorUtils.getConstructorFunctionWithZeroArguments(annotation.idResolver()).get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate id resolver: " + annotation.idResolver().getName(), e);
        }
    }
}

