/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotation;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.ConstructorUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.annotation.Internal;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.annotation.AnnotatedEntityMetamodel;
import org.axonframework.modelling.entity.annotation.AnnotatedEntityMetamodelFactory;
import org.axonframework.modelling.entity.annotation.CommandTargetResolverDefinition;
import org.axonframework.modelling.entity.annotation.EntityChildModelDefinition;
import org.axonframework.modelling.entity.annotation.EntityMember;
import org.axonframework.modelling.entity.annotation.EventTargetMatcherDefinition;
import org.axonframework.modelling.entity.child.CommandTargetResolver;
import org.axonframework.modelling.entity.child.EntityChildMetamodel;
import org.axonframework.modelling.entity.child.EventTargetMatcher;

@Internal
public abstract class AbstractEntityChildModelDefinition
implements EntityChildModelDefinition {
    @Override
    @Nonnull
    public <C, P> Optional<EntityChildMetamodel<C, P>> createChildDefinition(@Nonnull Class<P> parentClass, @Nonnull AnnotatedEntityMetamodelFactory metamodelFactory, @Nonnull Member member) {
        Map attributes = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)((AnnotatedElement)((Object)member)), EntityMember.class).orElse(null);
        Class memberValueType = ReflectionUtils.getMemberValueType((Member)member);
        if (attributes == null || !this.isMemberTypeSupported(memberValueType)) {
            return Optional.empty();
        }
        Class<?> childType = this.getChildTypeFromMember(member);
        AnnotatedEntityMetamodel<?> childModel = metamodelFactory.createMetamodelForType(childType);
        String fieldName = ReflectionUtils.fieldNameFromMember((Member)member);
        EventTargetMatcher<?> eventForwardingMode = this.constructForwardingDefinition(attributes).createChildEntityMatcher(childModel, member);
        CommandTargetResolver<?> commandForwardingMode = this.constructCommandChildEntityResolver(attributes).createCommandTargetResolver(childModel, member);
        return Optional.of(this.doCreate(parentClass, childModel, fieldName, eventForwardingMode, commandForwardingMode));
    }

    protected abstract boolean isMemberTypeSupported(@Nonnull Class<?> var1);

    protected abstract Class<?> getChildTypeFromMember(@Nonnull Member var1);

    @Nonnull
    protected abstract <C, P> EntityChildMetamodel<C, P> doCreate(@Nonnull Class<P> var1, @Nonnull EntityMetamodel<C> var2, @Nonnull String var3, @Nonnull EventTargetMatcher<C> var4, @Nonnull CommandTargetResolver<C> var5);

    private EventTargetMatcherDefinition constructForwardingDefinition(Map<String, Object> attributes) {
        Class definitionClazz = (Class)attributes.get("eventTargetMatcher");
        return (EventTargetMatcherDefinition)ConstructorUtils.getConstructorFunctionWithZeroArguments((Class)definitionClazz).get();
    }

    private CommandTargetResolverDefinition constructCommandChildEntityResolver(Map<String, Object> attributes) {
        Class definitionClazz = (Class)attributes.get("commandTargetResolver");
        return (CommandTargetResolverDefinition)ConstructorUtils.getConstructorFunctionWithZeroArguments((Class)definitionClazz).get();
    }
}

