/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.repository.jdbc.SagaSchema;
import org.axonframework.modelling.saga.repository.jdbc.SagaSqlSchema;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SimpleSerializedObject;

public class GenericSagaSqlSchema
implements SagaSqlSchema {
    private final SagaSchema sagaSchema;

    public GenericSagaSqlSchema() {
        this(new SagaSchema());
    }

    public GenericSagaSqlSchema(SagaSchema sagaSchema) {
        this.sagaSchema = sagaSchema;
    }

    @Override
    public PreparedStatement sql_loadSaga(Connection connection, String sagaId) throws SQLException {
        String sql = "SELECT serializedSaga, sagaType, revision FROM " + this.sagaSchema.sagaEntryTable() + " WHERE sagaId = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaId);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_removeAssocValue(Connection connection, String key, String value, String sagaType, String sagaIdentifier) throws SQLException {
        String sql = "DELETE FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE associationKey = ? AND associationValue = ? AND sagaType = ? AND sagaId = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, key);
        preparedStatement.setString(2, value);
        preparedStatement.setString(3, sagaType);
        preparedStatement.setString(4, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_storeAssocValue(Connection connection, String key, String value, String sagaType, String sagaIdentifier) throws SQLException {
        String sql = "INSERT INTO " + this.sagaSchema.associationValueEntryTable() + " (associationKey, associationValue, sagaType, sagaId) VALUES(?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, key);
        preparedStatement.setString(2, value);
        preparedStatement.setString(3, sagaType);
        preparedStatement.setString(4, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_findAssocSagaIdentifiers(Connection connection, String key, String value, String sagaType) throws SQLException {
        String sql = "SELECT sagaId FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE associationKey = ? AND associationValue = ? AND sagaType = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, key);
        preparedStatement.setString(2, value);
        preparedStatement.setString(3, sagaType);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_findAssociations(Connection connection, String sagaIdentifier, String sagaType) throws SQLException {
        String sql = "SELECT associationKey, associationValue FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE sagaId = ? AND sagaType = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        preparedStatement.setString(2, sagaType);
        return preparedStatement;
    }

    @Override
    public String readToken(ResultSet resultSet) {
        return null;
    }

    @Override
    public Set<AssociationValue> readAssociationValues(ResultSet resultSet) throws SQLException {
        HashSet<AssociationValue> associationValues = new HashSet<AssociationValue>();
        while (resultSet.next()) {
            associationValues.add(new AssociationValue(resultSet.getString(1), resultSet.getString(2)));
        }
        return associationValues;
    }

    @Override
    public PreparedStatement sql_deleteSagaEntry(Connection connection, String sagaIdentifier) throws SQLException {
        String sql = "DELETE FROM " + this.sagaSchema.sagaEntryTable() + " WHERE sagaId = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_deleteAssociationEntries(Connection connection, String sagaIdentifier) throws SQLException {
        String sql = "DELETE FROM " + this.sagaSchema.associationValueEntryTable() + " WHERE sagaId = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_updateSaga(Connection connection, String sagaIdentifier, byte[] serializedSaga, String sagaType, String revision) throws SQLException {
        String sql = "UPDATE " + this.sagaSchema.sagaEntryTable() + " SET serializedSaga = ?, revision = ? WHERE sagaId = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setBytes(1, serializedSaga);
        preparedStatement.setString(2, revision);
        preparedStatement.setString(3, sagaIdentifier);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_storeSaga(Connection connection, String sagaIdentifier, String revision, String sagaType, byte[] serializedSaga) throws SQLException {
        String sql = "INSERT INTO " + this.sagaSchema.sagaEntryTable() + "(sagaId, revision, sagaType, serializedSaga) VALUES(?,?,?,?)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaIdentifier);
        preparedStatement.setString(2, revision);
        preparedStatement.setString(3, sagaType);
        preparedStatement.setBytes(4, serializedSaga);
        return preparedStatement;
    }

    @Override
    public PreparedStatement sql_createTableAssocValueEntry(Connection conn) throws SQLException {
        String sql = "create table " + this.sagaSchema.associationValueEntryTable() + " (\n        id int not null AUTO_INCREMENT,\n        associationKey varchar(255),\n        associationValue varchar(255),\n        sagaId varchar(255),\n        sagaType varchar(255),\n        primary key (id)\n    );\n";
        return conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement sql_createTableSagaEntry(Connection conn) throws SQLException {
        return conn.prepareStatement("create table " + this.sagaSchema.sagaEntryTable() + " (\n        sagaId varchar(255) not null,\n        revision varchar(255),\n        sagaType varchar(255),\n        serializedSaga blob,\n        primary key (sagaId)\n    );");
    }

    public SerializedObject<byte[]> readSerializedSaga(ResultSet resultSet) throws SQLException {
        return new SimpleSerializedObject((Object)resultSet.getBytes(1), byte[].class, resultSet.getString(2), resultSet.getString(3));
    }

    public SagaSchema sagaSchema() {
        return this.sagaSchema;
    }
}

