/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.IdentifierMissingException;
import org.axonframework.modelling.command.TargetAggregateIdentifier;
import org.axonframework.modelling.command.TargetAggregateVersion;
import org.axonframework.modelling.command.VersionedAggregateIdentifier;

public class AnnotationCommandTargetResolver
implements CommandTargetResolver {
    private final Class<? extends Annotation> identifierAnnotation;
    private final Class<? extends Annotation> versionAnnotation;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public AnnotationCommandTargetResolver() {
        this.identifierAnnotation = TargetAggregateIdentifier.class;
        this.versionAnnotation = TargetAggregateVersion.class;
    }

    protected AnnotationCommandTargetResolver(Builder builder) {
        this.identifierAnnotation = builder.identifierAnnotation;
        this.versionAnnotation = builder.versionAnnotation;
    }

    @Override
    public VersionedAggregateIdentifier resolveTarget(@Nonnull CommandMessage<?> command) {
        Long aggregateVersion;
        Object aggregateIdentifier;
        try {
            aggregateIdentifier = this.findIdentifier((Message<?>)command);
            aggregateVersion = this.findVersion((Message<?>)command);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("An exception occurred while extracting aggregate information form a command", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The current security context does not allow extraction of aggregate information from the given command.", e);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The value provided for the version is not a number.", e);
        }
        if (aggregateIdentifier == null) {
            throw new IdentifierMissingException(String.format("Invalid command. It does not identify the target aggregate. Make sure at least one of the fields or methods in the [%s] class contains the @TargetAggregateIdentifier annotation and that it returns a non-null value.", command.getPayloadType().getSimpleName()));
        }
        return new VersionedAggregateIdentifier(aggregateIdentifier, aggregateVersion);
    }

    private Object findIdentifier(Message<?> command) throws InvocationTargetException, IllegalAccessException {
        return AnnotationCommandTargetResolver.invokeAnnotated(command, this.identifierAnnotation);
    }

    private Long findVersion(Message<?> command) throws InvocationTargetException, IllegalAccessException {
        return this.asLong(AnnotationCommandTargetResolver.invokeAnnotated(command, this.versionAnnotation));
    }

    private static Object invokeAnnotated(Message<?> command, Class<? extends Annotation> annotation) throws InvocationTargetException, IllegalAccessException {
        for (Method m : ReflectionUtils.methodsOf((Class)command.getPayloadType())) {
            if (!AnnotationUtils.isAnnotationPresent((AnnotatedElement)m, annotation)) continue;
            ReflectionUtils.ensureAccessible((AccessibleObject)m);
            return m.invoke(command.getPayload(), new Object[0]);
        }
        for (Field f : ReflectionUtils.fieldsOf((Class)command.getPayloadType())) {
            if (!AnnotationUtils.isAnnotationPresent((AnnotatedElement)f, annotation)) continue;
            return ReflectionUtils.getFieldValue((Field)f, (Object)command.getPayload());
        }
        return null;
    }

    private Long asLong(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).longValue();
        }
        return Long.parseLong(fieldValue.toString());
    }

    public String toString() {
        return "AnnotationCommandTargetResolver [identifierAnnotation=" + this.identifierAnnotation + ", versionAnnotation=" + this.versionAnnotation + "]";
    }

    public static final class Builder {
        private Class<? extends Annotation> identifierAnnotation = TargetAggregateIdentifier.class;
        private Class<? extends Annotation> versionAnnotation = TargetAggregateVersion.class;

        public Builder targetAggregateIdentifierAnnotation(Class<? extends Annotation> annotation) {
            BuilderUtils.assertNonNull(annotation, (String)"TargetAggregateIdentifierAnnotation may not be null");
            this.identifierAnnotation = annotation;
            return this;
        }

        public Builder targetAggregateVersionAnnotation(Class<? extends Annotation> annotation) {
            BuilderUtils.assertNonNull(annotation, (String)"TargetAggregateVersionAnnotation may not be null");
            this.versionAnnotation = annotation;
            return this;
        }

        public AnnotationCommandTargetResolver build() {
            return new AnnotationCommandTargetResolver(this);
        }
    }
}

