/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.ResetNotSupportedException;
import org.axonframework.eventhandling.Segment;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeAware;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.Saga;
import org.axonframework.modelling.saga.SagaCreationPolicy;
import org.axonframework.modelling.saga.SagaInitializationPolicy;
import org.axonframework.modelling.saga.SagaInstantiationException;
import org.axonframework.modelling.saga.SagaRepository;
import org.axonframework.modelling.saga.SagaScopeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSagaManager<T>
implements EventHandlerInvoker,
ScopeAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSagaManager.class);
    private final SagaRepository<T> sagaRepository;
    private final Class<T> sagaType;
    private final Supplier<T> sagaFactory;
    private volatile ListenerInvocationErrorHandler listenerInvocationErrorHandler;

    protected AbstractSagaManager(Builder<T> builder) {
        builder.validate();
        this.sagaRepository = ((Builder)builder).sagaRepository;
        this.sagaType = builder.sagaType;
        this.sagaFactory = ((Builder)builder).sagaFactory;
        this.listenerInvocationErrorHandler = ((Builder)builder).listenerInvocationErrorHandler;
    }

    public void handle(EventMessage<?> event, Segment segment) throws Exception {
        SagaInitializationPolicy initializationPolicy;
        Set<AssociationValue> associationValues = this.extractAssociationValues(event);
        List sagaIds = associationValues.stream().flatMap(associationValue -> this.sagaRepository.find((AssociationValue)associationValue).stream()).collect(Collectors.toList());
        Set sagas = sagaIds.stream().filter(sagaId -> this.matchesSegment(segment, (String)sagaId)).map(this.sagaRepository::load).filter(Objects::nonNull).filter(Saga::isActive).collect(Collectors.toCollection(HashSet::new));
        boolean sagaMatchesOtherSegment = sagaIds.stream().anyMatch(sagaId -> !this.matchesSegment(segment, (String)sagaId));
        boolean sagaOfTypeInvoked = false;
        for (Saga saga : sagas) {
            if (!this.doInvokeSaga(event, saga)) continue;
            sagaOfTypeInvoked = true;
        }
        if (this.shouldCreateSaga(segment, sagaOfTypeInvoked || sagaMatchesOtherSegment, initializationPolicy = this.getSagaCreationPolicy(event))) {
            this.startNewSaga(event, initializationPolicy.getInitialAssociationValue(), segment);
        }
    }

    private boolean shouldCreateSaga(Segment segment, boolean sagaInvoked, SagaInitializationPolicy initializationPolicy) {
        return (initializationPolicy.getCreationPolicy() == SagaCreationPolicy.ALWAYS || !sagaInvoked && initializationPolicy.getCreationPolicy() == SagaCreationPolicy.IF_NONE_FOUND) && segment.matches((Object)initializationPolicy.getInitialAssociationValue());
    }

    private void startNewSaga(EventMessage<?> event, AssociationValue associationValue, Segment segment) throws Exception {
        Saga<T> newSaga = this.sagaRepository.createInstance(this.createSagaIdentifier(segment), this.sagaFactory);
        newSaga.getAssociationValues().add(associationValue);
        this.doInvokeSaga(event, newSaga);
    }

    protected String createSagaIdentifier(Segment segment) {
        String identifier;
        while (!this.matchesSegment(segment, identifier = IdentifierFactory.getInstance().generateIdentifier())) {
        }
        return identifier;
    }

    protected boolean matchesSegment(Segment segment, String sagaId) {
        return segment.matches((Object)sagaId);
    }

    protected abstract SagaInitializationPolicy getSagaCreationPolicy(EventMessage<?> var1);

    protected abstract Set<AssociationValue> extractAssociationValues(EventMessage<?> var1);

    private boolean doInvokeSaga(EventMessage<?> event, Saga<T> saga) throws Exception {
        if (saga.canHandle((Message)event)) {
            try {
                saga.handle(event);
            }
            catch (Exception e) {
                this.listenerInvocationErrorHandler.onError(e, event, saga);
            }
            return true;
        }
        return false;
    }

    public Class<T> getSagaType() {
        return this.sagaType;
    }

    public boolean supportsReset() {
        return false;
    }

    public void performReset() {
        this.performReset(null);
    }

    public void performReset(Object resetContext) {
        throw new ResetNotSupportedException("Sagas do no support resetting tokens");
    }

    public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
        if (!(message instanceof EventMessage)) {
            String exceptionMessage = String.format("Something else than an EventMessage was scheduled for Saga of type [%s], whilst Sagas can only handle EventMessages.", this.getSagaType());
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (this.canResolve(scopeDescription)) {
            String sagaIdentifier = ((SagaScopeDescriptor)scopeDescription).getIdentifier().toString();
            Saga<T> saga = this.sagaRepository.load(sagaIdentifier);
            if (saga != null) {
                saga.handle((EventMessage)message);
            } else {
                logger.debug("Saga (with id: [{}]) cannot be loaded, as it most likely already ended. Hence, message [{}] cannot be handled.", (Object)sagaIdentifier, message);
            }
        }
    }

    public boolean canResolve(ScopeDescriptor scopeDescription) {
        return scopeDescription instanceof SagaScopeDescriptor && Objects.equals(this.sagaType.getSimpleName(), ((SagaScopeDescriptor)scopeDescription).getType());
    }

    public static abstract class Builder<T> {
        private SagaRepository<T> sagaRepository;
        protected Class<T> sagaType;
        private Supplier<T> sagaFactory = () -> Builder.newInstance(this.sagaType);
        private ListenerInvocationErrorHandler listenerInvocationErrorHandler = new LoggingErrorHandler();

        private static <T> T newInstance(Class<T> type) {
            try {
                return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new SagaInstantiationException("Exception while trying to instantiate a new Saga", e);
            }
        }

        public Builder<T> sagaRepository(SagaRepository<T> sagaRepository) {
            BuilderUtils.assertNonNull(sagaRepository, (String)"SagaRepository may not be null");
            this.sagaRepository = sagaRepository;
            return this;
        }

        public Builder<T> sagaType(Class<T> sagaType) {
            BuilderUtils.assertNonNull(sagaType, (String)"The sagaType may not be null");
            this.sagaType = sagaType;
            return this;
        }

        public Builder<T> sagaFactory(Supplier<T> sagaFactory) {
            BuilderUtils.assertNonNull(sagaFactory, (String)"The sagaFactory may not be null");
            this.sagaFactory = sagaFactory;
            return this;
        }

        public Builder<T> listenerInvocationErrorHandler(ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
            BuilderUtils.assertNonNull((Object)listenerInvocationErrorHandler, (String)"ListenerInvocationErrorHandler may not be null");
            this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.sagaRepository, (String)"The SagaRepository is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.sagaType, (String)"The sagaType is a hard requirement and should be provided");
        }
    }
}

