/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.AggregateRolledBackException;
import org.axonframework.modelling.command.AggregateScopeDescriptor;
import org.axonframework.modelling.command.ConflictingAggregateVersionException;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository<T, A extends Aggregate<T>>
implements Repository<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepository.class);
    private final String aggregatesKey = this + "_AGGREGATES";
    private final AggregateModel<T> aggregateModel;

    protected AbstractRepository(Builder<T> builder) {
        builder.validate();
        this.aggregateModel = builder.buildAggregateModel();
    }

    public A newInstance(Callable<T> factoryMethod) throws Exception {
        return this.newInstance(factoryMethod, a -> {});
    }

    public A newInstance(Callable<T> factoryMethod, Consumer<Aggregate<T>> initMethod) throws Exception {
        UnitOfWork uow = CurrentUnitOfWork.get();
        AtomicReference<A> aggregateReference = new AtomicReference<A>();
        uow.onPrepareCommit(x -> {
            Aggregate aggregate = (Aggregate)aggregateReference.get();
            if (aggregate != null && aggregate.identifier() != null) {
                this.prepareForCommit(aggregate);
            }
        });
        Object aggregate = this.doCreateNew(factoryMethod);
        initMethod.accept((Aggregate<A>)aggregate);
        aggregateReference.set(aggregate);
        Assert.isTrue((boolean)this.aggregateModel.entityClass().isAssignableFrom(aggregate.rootType()), () -> "Unsuitable aggregate for this repository: wrong type");
        Map aggregates = this.managedAggregates(uow);
        Assert.isTrue((aggregates.putIfAbsent(aggregate.identifierAsString(), aggregate) == null ? 1 : 0) != 0, () -> "The Unit of Work already has an Aggregate with the same identifier");
        uow.onRollback(u -> {
            Aggregate cfr_ignored_0 = (Aggregate)aggregates.remove(aggregate.identifierAsString());
        });
        return aggregate;
    }

    protected abstract A doCreateNew(Callable<T> var1) throws Exception;

    public A load(String aggregateIdentifier, Long expectedVersion) {
        UnitOfWork uow = CurrentUnitOfWork.get();
        Map aggregates = this.managedAggregates(uow);
        Aggregate aggregate = aggregates.computeIfAbsent(aggregateIdentifier, s -> this.doLoad(aggregateIdentifier, expectedVersion));
        uow.onRollback(u -> {
            Aggregate cfr_ignored_0 = (Aggregate)aggregates.remove(aggregateIdentifier);
        });
        this.validateOnLoad(aggregate, expectedVersion);
        this.prepareForCommit(aggregate);
        return (A)aggregate;
    }

    @Override
    public Aggregate<T> loadOrCreate(String aggregateIdentifier, Callable<T> factoryMethod) {
        UnitOfWork uow = CurrentUnitOfWork.get();
        Map aggregates = this.managedAggregates(uow);
        Aggregate aggregate = aggregates.computeIfAbsent(aggregateIdentifier, s -> {
            try {
                return this.doLoadOrCreate(aggregateIdentifier, factoryMethod);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        uow.onRollback(u -> {
            Aggregate cfr_ignored_0 = (Aggregate)aggregates.remove(aggregateIdentifier);
        });
        this.prepareForCommit(aggregate);
        return aggregate;
    }

    protected Map<String, A> managedAggregates(UnitOfWork<?> uow) {
        return (Map)uow.root().getOrComputeResource(this.aggregatesKey, s -> new HashMap());
    }

    public A load(String aggregateIdentifier) {
        return this.load(aggregateIdentifier, null);
    }

    protected void validateOnLoad(Aggregate<T> aggregate, Long expectedVersion) {
        if (expectedVersion != null && aggregate.version() != null && !expectedVersion.equals(aggregate.version())) {
            throw new ConflictingAggregateVersionException(aggregate.identifierAsString(), expectedVersion, aggregate.version());
        }
    }

    protected void prepareForCommit(A aggregate) {
        if (UnitOfWork.Phase.STARTED.isBefore(CurrentUnitOfWork.get().phase())) {
            this.doCommit(aggregate);
        } else {
            CurrentUnitOfWork.get().onPrepareCommit(u -> this.doCommit(aggregate));
        }
    }

    private void doCommit(A aggregate) {
        if (this.managedAggregates(CurrentUnitOfWork.get()).containsValue(aggregate)) {
            if (aggregate.isDeleted()) {
                this.doDelete(aggregate);
            } else {
                this.doSave(aggregate);
            }
            if (aggregate.isDeleted()) {
                this.postDelete(aggregate);
            } else {
                this.postSave(aggregate);
            }
        } else {
            this.reportIllegalState(aggregate);
        }
    }

    protected void reportIllegalState(A aggregate) {
        throw new AggregateRolledBackException(aggregate.identifierAsString());
    }

    protected AggregateModel<T> aggregateModel() {
        return this.aggregateModel;
    }

    protected Class<? extends T> getAggregateType() {
        return this.aggregateModel.entityClass();
    }

    protected abstract void doSave(A var1);

    protected abstract A doLoad(String var1, Long var2);

    protected A doLoadOrCreate(String aggregateIdentifier, Callable<T> factoryMethod) throws Exception {
        throw new UnsupportedOperationException("doLoadOrCreate not implemented for this repository type");
    }

    protected abstract void doDelete(A var1);

    protected void postSave(A aggregate) {
    }

    protected void postDelete(A aggregate) {
    }

    public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
        if (this.canResolve(scopeDescription)) {
            String aggregateIdentifier = ((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString();
            try {
                this.load(aggregateIdentifier).handle(message);
            }
            catch (AggregateNotFoundException e) {
                logger.debug("Aggregate (with id: [{}]) cannot be loaded. Hence, message '[{}]' cannot be handled.", (Object)aggregateIdentifier, message);
            }
        }
    }

    public boolean canResolve(ScopeDescriptor scopeDescription) {
        return scopeDescription instanceof AggregateScopeDescriptor && Objects.equals(this.aggregateModel.type(), ((AggregateScopeDescriptor)scopeDescription).getType());
    }

    public static abstract class Builder<T> {
        protected final Class<T> aggregateType;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private AggregateModel<T> aggregateModel;

        protected Builder(Class<T> aggregateType) {
            this.aggregateType = aggregateType;
        }

        public Builder<T> parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull((Object)parameterResolverFactory, (String)"ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder<T> handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull((Object)handlerDefinition, (String)"HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder<T> aggregateModel(AggregateModel<T> aggregateModel) {
            BuilderUtils.assertNonNull(aggregateModel, (String)"AggregateModel may not be null");
            this.aggregateModel = aggregateModel;
            return this;
        }

        protected AggregateModel<T> buildAggregateModel() {
            if (this.aggregateModel == null) {
                return this.inspectAggregateModel();
            }
            return this.aggregateModel;
        }

        private AggregateModel<T> inspectAggregateModel() {
            if (this.parameterResolverFactory == null && this.handlerDefinition == null) {
                return AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType);
            }
            if (this.parameterResolverFactory != null && this.handlerDefinition == null) {
                this.handlerDefinition = ClasspathHandlerDefinition.forClass(this.aggregateType);
            }
            return AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType, this.parameterResolverFactory, this.handlerDefinition);
        }

        protected void validate() throws AxonConfigurationException {
            if (this.aggregateModel == null) {
                BuilderUtils.assertNonNull(this.aggregateType, (String)"No AggregateModel is set, whilst either it or the aggregateType is a hard requirement");
                return;
            }
            BuilderUtils.assertNonNull(this.aggregateModel, (String)"No aggregateType is set, whilst either it or the AggregateModel is a hard requirement");
        }
    }
}

