/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandMessageHandlingMember;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.modelling.command.AggregateEntityNotFoundException;
import org.axonframework.modelling.command.inspection.AnnotatedCommandHandlerInterceptor;

public class ChildForwardingCommandMessageHandlingMember<P, C>
implements CommandMessageHandlingMember<P> {
    private final List<MessageHandlingMember<? super C>> childHandlingInterceptors;
    private final MessageHandlingMember<? super C> childHandler;
    private final BiFunction<CommandMessage<?>, P, C> childEntityResolver;
    private final String commandName;
    private final boolean isFactoryHandler;

    public ChildForwardingCommandMessageHandlingMember(List<MessageHandlingMember<? super C>> childHandlerInterceptors, MessageHandlingMember<? super C> childHandler, BiFunction<CommandMessage<?>, P, C> childEntityResolver) {
        this.childHandlingInterceptors = childHandlerInterceptors;
        this.childHandler = childHandler;
        this.childEntityResolver = childEntityResolver;
        this.commandName = childHandler.unwrap(CommandMessageHandlingMember.class).map(CommandMessageHandlingMember::commandName).orElse(null);
        this.isFactoryHandler = childHandler.unwrap(CommandMessageHandlingMember.class).map(CommandMessageHandlingMember::isFactoryHandler).orElse(false);
    }

    public String commandName() {
        return this.commandName;
    }

    public String routingKey() {
        return null;
    }

    public boolean isFactoryHandler() {
        return this.isFactoryHandler;
    }

    public Class<?> payloadType() {
        return this.childHandler.payloadType();
    }

    public int priority() {
        return Integer.MIN_VALUE;
    }

    public boolean canHandle(Message<?> message) {
        return this.childHandler.canHandle(message);
    }

    public boolean canHandleMessageType(Class<? extends Message> messageType) {
        return this.childHandler.canHandleMessageType(messageType);
    }

    public Object handle(Message<?> message, P target) throws Exception {
        Object childEntity = this.childEntityResolver.apply((CommandMessage)message, target);
        if (childEntity == null) {
            throw new AggregateEntityNotFoundException("Aggregate cannot handle command [" + ((CommandMessage)message).getCommandName() + "], as there is no entity instance within the aggregate to forward it to.");
        }
        List interceptors = this.childHandlingInterceptors.stream().filter(chi -> chi.canHandle(message)).sorted((chi1, chi2) -> Integer.compare(chi2.priority(), chi1.priority())).map(chi -> new AnnotatedCommandHandlerInterceptor<Object>((MessageHandlingMember<Object>)chi, childEntity)).collect(Collectors.toList());
        Object result = interceptors.isEmpty() ? this.childHandler.handle(message, childEntity) : new DefaultInterceptorChain(CurrentUnitOfWork.get(), interceptors, m -> this.childHandler.handle(message, childEntity)).proceed();
        return result;
    }

    public <HT> Optional<HT> unwrap(Class<HT> handlerType) {
        if (handlerType.isInstance(this)) {
            return Optional.of(this);
        }
        return this.childHandler.unwrap(handlerType);
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.childHandler.hasAnnotation(annotationType);
    }

    public Optional<Map<String, Object>> annotationAttributes(Class<? extends Annotation> annotationType) {
        return this.childHandler.annotationAttributes(annotationType);
    }

    public <R> Optional<R> attribute(String attributeKey) {
        return this.childHandler.attribute(attributeKey);
    }
}

