/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.inmemory;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.AssociationValues;
import org.axonframework.modelling.saga.repository.SagaStore;

public class InMemorySagaStore
implements SagaStore<Object> {
    private final ConcurrentMap<String, ManagedSaga> managedSagas = new ConcurrentHashMap<String, ManagedSaga>();

    @Override
    public Set<String> findSagas(Class<?> sagaType, AssociationValue associationValue) {
        return this.managedSagas.entrySet().stream().filter(avEntry -> sagaType.isInstance(((ManagedSaga)avEntry.getValue()).saga())).filter(avEntry -> ((ManagedSaga)avEntry.getValue()).associationValues().contains(associationValue)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public void deleteSaga(Class<?> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        this.managedSagas.remove(sagaIdentifier);
    }

    @Override
    public <S> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        return (SagaStore.Entry)this.managedSagas.get(sagaIdentifier);
    }

    @Override
    public void insertSaga(Class<?> sagaType, String sagaIdentifier, Object saga, Set<AssociationValue> associationValues) {
        this.managedSagas.put(sagaIdentifier, new ManagedSaga(saga, associationValues));
    }

    @Override
    public void updateSaga(Class<?> sagaType, String sagaIdentifier, Object saga, AssociationValues associationValues) {
        this.managedSagas.put(sagaIdentifier, new ManagedSaga(saga, associationValues.asSet()));
    }

    public int size() {
        return this.managedSagas.size();
    }

    private static class ManagedSaga
    implements SagaStore.Entry<Object> {
        private final Object saga;
        private final Set<AssociationValue> associationValues;

        public ManagedSaga(Object saga, Set<AssociationValue> associationValues) {
            this.saga = saga;
            this.associationValues = associationValues;
        }

        @Override
        public Set<AssociationValue> associationValues() {
            return this.associationValues;
        }

        @Override
        public Object saga() {
            return this.saga;
        }
    }
}

