/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.modelling.saga.ResourceInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceInjector
implements ResourceInjector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceInjector.class);
    private static final String[] DEFAULT_INJECT_ANNOTATIONS = new String[]{"javax.inject.Inject", "org.springframework.beans.factory.annotation.Autowired"};

    @Override
    public void injectResources(Object saga) {
        this.injectFieldResources(saga);
        this.injectMethodResources(saga);
    }

    private void injectFieldResources(Object saga) {
        ReflectionUtils.fieldsOf(saga.getClass()).forEach(field -> Stream.of(this.injectorAnnotationNames()).filter(ann -> AnnotationUtils.isAnnotationPresent((AnnotatedElement)field, (String)ann)).forEach(annotatedFields -> {
            Class<?> requiredType = field.getType();
            this.findResource(requiredType).ifPresent(resource -> this.injectFieldResource(saga, (Field)field, resource));
        }));
    }

    protected abstract <R> Optional<R> findResource(Class<R> var1);

    private void injectFieldResource(Object saga, Field injectField, Object resource) {
        try {
            ReflectionUtils.ensureAccessible((AccessibleObject)injectField);
            injectField.set(saga, resource);
        }
        catch (IllegalAccessException e) {
            logger.warn("Unable to inject resource. Exception while setting field: ", (Throwable)e);
        }
    }

    private void injectMethodResources(Object saga) {
        ReflectionUtils.methodsOf(saga.getClass()).forEach(method -> Stream.of(this.injectorAnnotationNames()).filter(a -> AnnotationUtils.isAnnotationPresent((AnnotatedElement)method, (String)a)).forEach(a -> {
            Class<?> requiredType = method.getParameterTypes()[0];
            this.findResource(requiredType).ifPresent(resource -> this.injectMethodResource(saga, (Method)method, resource));
        }));
    }

    private void injectMethodResource(Object saga, Method injectMethod, Object resource) {
        try {
            ReflectionUtils.ensureAccessible((AccessibleObject)injectMethod);
            injectMethod.invoke(saga, resource);
        }
        catch (IllegalAccessException e) {
            logger.warn("Unable to inject resource. Exception while invoking setter: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("Unable to inject resource. Exception while invoking setter: ", e.getCause());
        }
    }

    protected String[] injectorAnnotationNames() {
        return DEFAULT_INJECT_ANNOTATIONS;
    }
}

