/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.axonframework.common.jdbc.Oracle11Utils;
import org.axonframework.modelling.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.modelling.saga.repository.jdbc.SagaSchema;

public class Oracle11SagaSqlSchema
extends GenericSagaSqlSchema {
    public Oracle11SagaSqlSchema(SagaSchema sagaSchema) {
        super(sagaSchema);
    }

    @Override
    public PreparedStatement sql_createTableAssocValueEntry(Connection conn) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement("create table " + this.sagaSchema().associationValueEntryTable() + " (\n        id number(38) not null,\n        " + this.sagaSchema.associationKeyColumn() + " varchar(255),\n        " + this.sagaSchema.associationValueColumn() + " varchar(255),\n        " + this.sagaSchema.sagaIdColumn() + " varchar(255),\n        " + this.sagaSchema.sagaTypeColumn() + " varchar(255),\n        primary key (id)\n    )");){
            pst.executeUpdate();
        }
        Oracle11Utils.simulateAutoIncrement((Connection)conn, (String)this.sagaSchema().associationValueEntryTable(), (String)"id");
        return Oracle11Utils.createNullStatement((Connection)conn);
    }

    @Override
    public PreparedStatement sql_createTableSagaEntry(Connection conn) throws SQLException {
        return conn.prepareStatement("create table " + this.sagaSchema().sagaEntryTable() + " (\n        " + this.sagaSchema.sagaIdColumn() + " varchar(255) not null,\n        " + this.sagaSchema.revisionColumn() + " varchar(255),\n        " + this.sagaSchema.sagaTypeColumn() + " varchar(255),\n        " + this.sagaSchema.serializedSagaColumn() + " blob,\n        primary key (" + this.sagaSchema.sagaIdColumn() + ")\n    )");
    }
}

